#ifndef _CPU_MON_H_
#define _CPU_MON_H_

#include <vdr/plugin.h>

#include "parms.h"
#include "cpumonsetup.h"
#include "cpumonosd.h"

static const char *VERSION        = "0.0.6a";
static const char *DESCRIPTION    = "CPU Monitor";
static const char *MAINMENUENTRY  = "CPU Monitor";

// ---------------------------------------------------------------------

class cPluginCpuMon : public cPlugin {
private:
  cCpuMonFetcher *Values_Fetcher;
  cParameters *parms;  
public:
  
  // Constructor and Destructor
  cPluginCpuMon(void);
  virtual ~cPluginCpuMon();

  virtual const char *Version(void) { return VERSION; };
  virtual const char *Description(void) { return trNOOP(DESCRIPTION); };
  virtual const char *CommandLineHelp(void);
  virtual bool ProcessArgs(int argc, char *argv[]);
  virtual bool Initialize(void);
  virtual bool Start(void);
  virtual void Stop(void);
  virtual void Housekeeping(void);
  virtual void MainThreadHook(void);
  virtual cString Active(void);
  virtual const char *MainMenuEntry(void) { return trNOOP(MAINMENUENTRY); };
  virtual cOsdObject *MainMenuAction(void);
  virtual cMenuSetupPage *SetupMenu(void);
  virtual bool SetupParse(const char *Name, const char *Value);
  virtual bool Service(const char *Id, void *Data = NULL);
  virtual const char **SVDRPHelpPages(void);
  virtual cString SVDRPCommand(const char *Command, const char *Option, int &ReplyCode);
};

#endif
