/*
 * autotimeredit: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: vdrtools.c 1.8 2005/11/07 16:47:18 hflor Exp $
 */

#include "vdrtools.h"

#if VDRVERSNUM < 10318
// --- cReadLine -------------------------------------------------------------

cReadLine::cReadLine(void)
{
  size = 0;
  buffer = NULL;
}

cReadLine::~cReadLine()
{
  free(buffer);
}

char *cReadLine::Read(FILE *f)
{
  int n = getline(&buffer, &size, f);
  if (n > 0) {
     n--;
     if (buffer[n] == '\n')
        buffer[n] = 0;
     return buffer;
     }
  return NULL;
}
#endif

char *SkipQuote(char *s)
{
  char c = *s;
  strcpy(s, s + 1);
  while (*s && *s != c) {
    if (*s == '\\')
      strcpy(s, s + 1);
    if (*s)
      s++;
  }
  if (*s) {
    strcpy(s, s + 1);
    return s;
  }
  esyslog("ERROR: missing closing %c", c);
  return NULL;
}

#ifdef ATE_Debug
char *KeyName(eKeys Key)
{
  char *name = NULL;
  static char *fullname = NULL;
  switch (RAWKEY(Key)) {
    case kUp:         name = "kUp";         break;
    case kDown:       name = "kDown";       break;
    case kMenu:       name = "kMenu";       break;
    case kOk:         name = "kOk";         break;
    case kBack:       name = "kBack";       break;
    case kLeft:       name = "kLeft";       break;
    case kRight:      name = "kRight";      break;
    case kRed:        name = "kRed";        break;
    case kGreen:      name = "kGreen";      break;
    case kYellow:     name = "kYellow";     break;
    case kBlue:       name = "kBlue";       break;
    case k0:          name = "k0";          break;
    case k1:          name = "k1";          break;
    case k2:          name = "k2";          break;
    case k3:          name = "k3";          break;
    case k4:          name = "k4";          break;
    case k5:          name = "k5";          break;
    case k6:          name = "k6";          break;
    case k7:          name = "k7";          break;
    case k8:          name = "k8";          break;
    case k9:          name = "k9";          break;
    case kPlay:       name = "kPlay";       break;
    case kPause:      name = "kPause";      break;
    case kStop:       name = "kStop";       break;
    case kRecord:     name = "kRecord";     break;
    case kFastFwd:    name = "kFastFwd";    break;
    case kFastRew:    name = "kFastRew";    break;
    case kPower:      name = "kPower";      break;
    case kChanUp:     name = "kChanUp";     break;
    case kChanDn:     name = "kChanDn";     break;
    case kVolUp:      name = "kVolUp";      break;
    case kVolDn:      name = "kVolDn";      break;
    case kMute:       name = "kMute";       break;
    case kSchedule:   name = "kSchedule";   break;
    case kChannels:   name = "kChannels";   break;
    case kTimers:     name = "kTimers";     break;
    case kRecordings: name = "kRecordings"; break;
    case kSetup:      name = "kSetup";      break;
    case kCommands:   name = "kCommands";   break;
    case kUser1:      name = "kUser1";      break;
    case kUser2:      name = "kUser2";      break;
    case kUser3:      name = "kUser3";      break;
    case kUser4:      name = "kUser4";      break;
    case kUser5:      name = "kUser5";      break;
    case kUser6:      name = "kUser6";      break;
    case kUser7:      name = "kUser7";      break;
    case kUser8:      name = "kUser8";      break;
    case kUser9:      name = "kUser9";      break;
    case kNone:       name = "kNone";       break;
    case kKbd:        name = "kKbd";        break;
    case k_Plugin:    name = "k_Plugin";    break;
    case k_Setup:     name = "k_Setup";     break;
    case k_Repeat:    break;
    case k_Release:   break;
    case k_Flags:     break;
  }
  free(fullname);
  fullname = strdup(name);
  if (Key & k_Repeat) {
    free(fullname);
    asprintf(&fullname, "%s (Repeat)", name);
  }
  if (Key & k_Release) {
    free(fullname);
    asprintf(&fullname, "%s (Release)", name);
  }
  return fullname;
}

char *OSStateName(eOSState OSState)
{
  switch (OSState) {
    case osUnknown:    return "osUnknown";
    case osContinue:   return "osContinue";
    case osSchedule:   return "osSchedule";
    case osChannels:   return "osChannels";
    case osTimers:     return "osTimers";
    case osRecordings: return "osRecordings";
    case osPlugin:     return "osPlugin";
    case osSetup:      return "osSetup";
    case osCommands:   return "osCommands";
    case osPause:      return "osPause";
    case osRecord:     return "osRecord";
    case osReplay:     return "osReplay";
    case osStopRecord: return "osStopRecord";
    case osStopReplay: return "osStopReplay";
    case osCancelEdit: return "osCancelEdit";
    case osSwitchDvb:  return "osSwitchDvb";
    case osBack:       return "osBack";
    case osEnd:        return "osEnd";
    case os_User:      return "os_User";
    case osUser1:      return "osUser1";
    case osUser2:      return "osUser2";
    case osUser3:      return "osUser3";
    case osUser4:      return "osUser4";
    case osUser5:      return "osUser5";
    case osUser6:      return "osUser6";
    case osUser7:      return "osUser7";
    case osUser8:      return "osUser8";
    case osUser9:      return "osUser9";
    case osUser10:     return "osUser10";
#if VDRVERSNUM < 10300
    case osUser11:     return "osUser11";
    case osUser12:     return "osUser12";
#endif
  }
  return "";
}
#endif
