/*
 * autotimeredit: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: update.c 1.2 2004/05/13 09:09:20 hflor Exp $
 */

#include "update.h"
#include "autotimeredit.h"

cUpdateThread::cUpdateThread(char *RunCMD)
{
  if (RunCMD && strlen(RunCMD))
    cmd = strdup(RunCMD);
  else
    cmd = NULL;
  starttime = time(NULL);
}

cUpdateThread::~cUpdateThread(void)
{
  if (cmd)
    free(cmd);
}

void cUpdateThread::Action(void)
{
  pid = getpid();
#ifdef ATE_Debug2
  dsyslog("%s: Update-Thread started (pid=%d) cmd=%s", plugin_name, pid, cmd);
#endif
  SystemExec(cmd);
#ifdef ATE_Debug2
  dsyslog("%s: Update-Thread ended (pid=%d)", plugin_name, pid);
#endif
  pid = -1;
}

void cUpdateThread::Stop(void)
{
  Cancel();
}
