/*
 * autotimeredit: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: menuautotimer.h 1.7 2005/10/19 23:22:17 hflor Exp $
 */

#ifndef __MENUAUTOTIMER_H
#define __MENUAUTOTIMER_H

#include <vdr/menu.h>
#include <vdr/menuitems.h>
#include "autotimers.h"

// --- cMenuEditAutoTimer --------------------------------------------------------

class cMenuEditAutoTimer : public cOsdMenu {
private:
  cAutoTimer *autotimer;
  cAutoTimer data;
  int selStartStopTime;
  int channel;
  int selWeekdays;
  bool isdictionarselect;
  int dictionarypos;
  int dictionarysel;
  bool addIfConfirmed;
public:
  cMenuEditAutoTimer(cAutoTimer *AutoTimer, bool New = false);
  virtual ~cMenuEditAutoTimer();
  virtual void Set(void);
  virtual eOSState ProcessKey(eKeys Key);
  };

// --- cMenuAutoTimerItem --------------------------------------------------------

class cMenuAutoTimerItem : public cOsdItem {
private:
  cAutoTimer *autotimer;
public:
  cMenuAutoTimerItem(cAutoTimer *AutoTimer);
#if VDRVERSNUM >= 10315
  virtual int Compare(const cListObject &ListObject) const;
#else
  virtual bool operator< (const cListObject &ListObject);
#endif
  virtual void Set(void);
  cAutoTimer *AutoTimer(void) { return autotimer; }
  };

// --- cMenuAutoTimers -----------------------------------------------------------

class cMenuAutoTimers : public cOsdMenu {
private:
  bool updateTop;
  bool updateBottom;
  bool IsAutoTimerItem(void);
  void SetHelpKeys(void);
  eOSState Edit(void);
  eOSState New(void);
  eOSState Delete(void);
  eOSState OnOff(void);
  cAutoTimer *CurrentAutoTimer(void);
public:
  cMenuAutoTimers(void);
  void AddUpdate(void);
  void DelUpdate(void);
  virtual eOSState ProcessKey(eKeys Key);
  };

#endif //__MENUAUTOTIMER_H
