/*
 * autotimeredit: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: autotimers.h 1.7 2005/10/19 23:22:17 hflor Exp $
 */

#ifndef __AUTOTIMERS_H
#define __AUTOTIMERS_H

#include <vdr/interface.h>
#include <vdr/thread.h>

enum eSearchpos {
  Searchpos_none        = 0x00,
  Searchpos_Title       = 0x01,
  Searchpos_Subtitle    = 0x02,
  Searchpos_Description = 0x04,
  Searchpos_All         = 0x07 };

class cAutoTimer : public cListObject {
  friend class cMenuEditAutoTimer;
private:
  int      active;
  char     search[MaxFileName];
  int      options;
  int      useStart;
  int      startTime;
  int      useStop;
  int      stopTime;
  int      serie;
  int      priority;
  int      lifetime;
  int      useChannel;
  cChannel *channel;
  bool     store_cid;
  char     folder[MaxFileName];
  int      except_repeat;
  int      weekdays;

  static char *buffer;
public:
  cAutoTimer(void);
  virtual ~cAutoTimer(void);
  cAutoTimer& operator= (const cAutoTimer &AutoTimer);
  bool operator== (const cAutoTimer &AutoTimer);
  bool operator!= (const cAutoTimer &AutoTimer);
#if VDRVERSNUM >= 10315
  virtual int Compare(const cListObject &ListObject) const;
#else
  virtual bool operator< (const cListObject &ListObject);
#endif

  int Active(void) { return active; }
  const char *Search(void) { return search; }
  int Options(void) { return options; }
  int UseStart(void) { return useStart; }
  int StartTime(void) { return startTime; }
  int UseStop(void) { return useStop; }
  int StopTime(void) { return stopTime; }
  int Serie(void) { return serie; }
  int Priority(void) { return priority; }
  int Lifetime(void) { return lifetime; }
  int UseChannel(void) { return useChannel; }
  cChannel *Channel(void) { return channel; }
  bool Store_CID(void) { return store_cid; }
  const char *Folder(void) { return folder; }
  int Except_Repeat(void) { return except_repeat; }
  int Weekdays(void) { return weekdays; }

  const char *ToText(void);
  bool Parse(const char *s);
  bool Save(FILE *f);
  void OnOff(void);
  };

class cAutoTimers : public cConfig<cAutoTimer> {
private:
  char  user[MaxFileName];
  char  pass[MaxFileName];
  char  addr[MaxFileName];
  int   port;
public:
  cAutoTimers(void);

  pid_t GetUpdatePID(void);
  bool  ParseConfig(void);
  bool  TestUpdate(bool ErrorToScreen);
  bool  RunUpdate(void);
  bool  Use_CID(void);
  };

extern cAutoTimers AutoTimers;

#endif //__AUTOTIMERS_H
