#!/bin/sh

set -e

echo "Running unit test of YouTube service defintions."
echo

echo -n "Checking main page..."
mainurl="http://www.youtube.com/browse?s=mp"
mainpage=`curl -sL "$mainurl" | xsltproc --nonet --html ../services/youtube/categories.xsl - 2> /dev/null`

nlinks=`echo $mainpage | xmllint --format - | egrep -c "<link" -`
if [ $nlinks -lt 3 ]; then
    echo -e "\nError: No links on main page $mainurl!"
    exit 1
fi

ntitles=`echo $mainpage | xmllint --format - | egrep -c "<title>[^<]+</title>" -`
if [ $ntitles -ne $nlinks ]; then
    echo -e "\nError: Some links do not have titles on main page $mainurl."
    exit 1
fi

nurls=`echo $mainpage | xmllint --format - | egrep -c "<url>[^<]+</url>" -`
if [ $nurls -ne $nlinks ]; then
    echo -e "\nError: Some links do not have urls on main page $mainurl."
    exit 1
fi

echo "OK"

# select the second URL for testing the navigation template
naviurl=`echo $mainpage | xmllint --format - | sed -n 's/<url>\(.*\)<\/url>/\1/p' - | head --lines=2 | tail --lines=1 | sed 's/^[ \t]*//' - | sed 's/\&amp;/\&/g' -`

#for url in `echo $mainpage | xmllint --format - | sed -n 's/<url>\(.*\)<\/url>/\1/p' -`
#do
#    echo $url
#done

echo -n "Checking navigation page $naviurl..."

navigationpage=`curl -sL "$naviurl" | xsltproc --nonet --html ../services/youtube/navigation.xsl - 2> /dev/null`

nlinks=`echo $navigationpage | xmllint --format - | egrep -c "<link" -`
if [ $nlinks -lt 2 ]; then
    echo -e "\nError: No links on a navigation page $naviurl!"
    exit 1
fi

ntitles=`echo $navigationpage | xmllint --format - | egrep -c "<title>[^<]+</title>" -`
if [ $ntitles -ne $nlinks ]; then
    echo -e "\nError: Some links do not have titles on navigation page $naviurl."
    exit 1
fi

nurls=`echo $navigationpage | xmllint --format - | egrep -c "<url>[^<]+</url>" -`
if [ $nurls -ne $nlinks ]; then
    echo -e "\nError: Some links do not have urls on navigation page $naviurl."
    exit 1
fi

echo "OK"

# select the first URL for testing the video template
videourl=`echo $navigationpage | xmllint --format - | sed -n 's/<url>\(.*\)<\/url>/\1/p' - | head --lines=1 | sed 's/^[ \t]*//' - | sed 's/\&amp;/\&/g' -`

echo -n "Checking video page $videourl..."

videopage=`curl -sL "$videourl" | xsltproc --nonet --html ../services/youtube/video.xsl - 2> /dev/null`

ntitles=`echo $videopage | xmllint --format - | egrep -c "<title>[^<]+</title>" -`
if [ $ntitles -ne 1 ]; then
    echo -e "\nError: Video title missing on page $videopage."
fi

nurls=`echo $videopage | xmllint --format - | egrep -c "<url>[^<]+</url>" -`
if [ $nurls -ne 1 ]; then
    echo -e "\nError: Video url missing on page $videourl."
    exit 1
fi

echo "OK"
echo
