#!/usr/bin/python
import urllib2
import sys
import popen2
import re
import htmlentitydefs

def convert_entity(m):
    text = m.group(0)
    try:
        return htmlentitydefs.entitydefs[text[1:-1]]
    except KeyError:
        pass
    return text

def load_and_apply_XSLT(url, xsltfile):

	#fetch the web page with correct headers
	req = urllib2.Request(url)
	req.add_header('User-agent', 'Mozilla/5.0 (Windows; U; Windows NT 5.1; sv-SE; rv:1.9.0.1) Gecko/2008070208 Firefox/3.0.1')
	req.add_header('Accept', '*/*')
	req.add_header('Accept-Language', 'en-us,en;q=0.5')
	req.add_header('Accept-Encoding', 'gzip,deflate')
	req.add_header('Accept-Charset', 'ISO-8859-1,utf-8;q=0.7,*;q=0.7')
	page = urllib2.urlopen(req).read()

	(childstdout, childstdin) = popen2.popen2('xsltproc --nonet --html %s - 2> /dev/null | xmllint --format -' % xsltfile)
	childstdin.write(page)
	childstdin.close()
	xml = childstdout.read()
	childstdout.close()
	return xml

def check_links(xml, url, pagename, requireurls=True):
    links = re.findall(r'<link[^>]*>', xml)
    nlinks = len(links)
    if nlinks < 1:
        print '\nError: No links on %s page %s!' % (pagename, url)
        sys.exit(1)

    ntitles = len(re.findall(r'<title>[^<]+</title>', xml))
    if ntitles != nlinks:
        print '\nError: Some links do not have titles on %s page %s.' % (pagename, url)
        sys.exit(1)

    urls = re.findall(r'<url>[^<]+</url>', xml)
    nurls = len(urls)
    if requireurls and (nurls != nlinks):
        print  '\nError: Some links do not have urls on %s page %s.' % (pagename, url)
        sys.exit(1)

    return (links, urls)

print 'Running unit test of SVT Play Video service defintions.\n'

######

print 'Checking main page...'

mainurl = 'http://svt.se/svt/road/Classic/shared/mediacenter/navigation.jsp?&d=37591' #main menu
mainpagexml = load_and_apply_XSLT(mainurl, '../services/svtplay/navigation.xsl')

(links, urls) = check_links(mainpagexml, mainurl, 'main', requireurls=False)
print "main page contains %d links" % len(links)
if len(links) == 11:
	print 'OK.'
else:
	print 'error'

print 'Checking page with navigation links and video...'
navigationpageurl = 'http://svt.se/svt/road/Classic/shared/mediacenter/navigation.jsp?&d=37717' #menu + video
navigationpagexml = load_and_apply_XSLT(navigationpageurl, '../services/svtplay/navigation.xsl')

(links2, urls2) = check_links(navigationpagexml, navigationpageurl, 'aktuellt', requireurls=False)
print "page contains %d links" % len(links2)
if len(links2) == 4:
        print 'OK.'
else:
        print 'error'


print 'Checking video page with .flv movie content...'
videourl1 = 'http://svt.se/svt/road/Classic/shared/mediacenter/player.jsp?a=716369&amp;d=37717'  # .flv movie
videopagexml1 = load_and_apply_XSLT(videourl1, '../services/svtplay/video.xsl')

print 'Checking video page with .asx movie...'
videourl2 = 'http://svt.se/svt/road/Classic/shared/mediacenter/player.jsp?a=937657&amp;d=75966'
videopagexml2 = load_and_apply_XSLT(videourl2, '../services/svtplay/video.xsl')

print 'OK'

