<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:template match="/">
<page>
  <xsl:for-each select="//div[@class='rl-item']">
    <xsl:choose>
      <xsl:when test="contains(div/@srcurl, 'www.youtube.com')">
	<link type="video" template="youtubevideo">
	  <title><xsl:value-of select="normalize-space(div/div/div[@class='rl-title']/a)" /></title>
	  <url><xsl:value-of select="div/@srcurl"/></url>
	</link>
      </xsl:when>

      <xsl:when test="contains(div/@srcurl, 'video.google.com')">
	<link type="video" template="googlevideo">
	  <title><xsl:value-of select="normalize-space(div/div/div[@class='rl-title']/a)"/></title>
	  <url><xsl:value-of select="div/@srcurl"/></url>
	</link>
      </xsl:when>
    </xsl:choose>
  </xsl:for-each>

  <xsl:if test="//td[@class='prev']/a">
    <link type="navigation-previous" template="searchresults">
      <title>Previous</title>
      <url>http://video.google.com<xsl:value-of select="//td[@class='prev']/a/@href"/></url>
    </link>
  </xsl:if>

  <xsl:if test="//td[@class='next']/a">
    <link type="navigation-next" template="searchresults">
      <title>Next</title>
      <url>http://video.google.com<xsl:value-of select="//td[@class='next']/a/@href"/></url>
    </link>
  </xsl:if>
</page>
</xsl:template>

</xsl:stylesheet>
