<?xml version="1.0" encoding="ISO-8859-1"?>

<xsl:stylesheet version="1.0"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:str="http://exslt.org/strings">

<xsl:template match="/">
<page>
  <xsl:for-each select="//div[@class='Title']">
    <xsl:choose>
      <xsl:when test="contains(substring-before(substring-after(a/@href, 'srcurl='), '&amp;'), 'www.youtube.com')">
	<link type="video" template="youtubevideo">
	  <title><xsl:value-of select="a"/></title>
	  <url><xsl:value-of select="str:decode-uri(substring-before(substring-after(a/@href, 'srcurl='), '&amp;'))"/></url>
	</link>
      </xsl:when>

      <xsl:when test="contains(substring-before(substring-after(a/@href, 'srcurl='), '&amp;'), 'video.google.com')">
	<link type="video" template="googlevideo">
	  <title><xsl:value-of select="a"/></title>
	  <url><xsl:value-of select="str:decode-uri(substring-before(substring-after(a/@href, 'srcurl='), '&amp;'))"/></url>
	</link>
      </xsl:when>
    </xsl:choose>
  </xsl:for-each>

  <xsl:if test="//td[@class='prev']">
    <link type="navigation-previous">
      <title>Previous</title>
      <url>http://video.google.com<xsl:value-of select="//td[@class='prev']/div[1]/a/@href"/></url>
    </link>
  </xsl:if>

  <xsl:if test="//td[@class='next']">
    <link type="navigation-next">
      <title>Next</title>
      <url>http://video.google.com<xsl:value-of select="//td[@class='next']/div[1]/a/@href"/></url>
    </link>
  </xsl:if>
</page>
</xsl:template>

</xsl:stylesheet>
