/*
 * service.h: Web video plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */

#ifndef __WEBVIDEO_SERVICE_H
#define __WEBVIDEO_SERVICE_H

#include <vdr/tools.h>
#include <libxml/xmlmemory.h>

class cVideoService : public cListObject {
private:
  char *title;
  char *url;
  char *templatefile;
  char *configpath;
public:
  cVideoService();
  ~cVideoService();

  virtual int Compare(const cListObject &ListObject) const;
  char *GetTitle() { return title; }
  char *GetURL() { return url; }
  char *GetTemplate() { return templatefile; }
  char *GetConfigDir() { return configpath; }

  bool TryParse(const char *path, const char *filename);
};

#endif // __WEBVIDEO_SERVICE_H
