/*
 * service.h: Web video plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */

#include <strings.h>
#include <vdr/i18n.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include "service.h"
#include "common.h"

cVideoService::cVideoService()
{
  title = NULL;
  url = NULL;
  templatefile = NULL;
  configpath = NULL;
}

cVideoService::~cVideoService()
{
  if (title)
    free(title);
  if (url)
    free(url);
  if (templatefile)
    free(templatefile);
  if (configpath)
    free(configpath);
}

bool cVideoService::TryParse(const char *path, const char *filename)
{
  xmlDoc *doc = NULL;
  xmlNode *node = NULL;

  // Store config path
  configpath = strdup(path);
  if (!configpath)
    return false;

  // construct full name for the config file
  cString fullpath = AddDirectory(configpath, filename);
  
  // Parse xml file
  doc = xmlReadFile(fullpath, NULL, 0);
  if (!doc)
    return false;

  node = xmlDocGetRootElement(doc);
  if (!node) {
    xmlFreeDoc(doc);
    return false;
  }

  title = NULL;
  url = NULL;
  templatefile = NULL;
  xmlChar *tmp;
  node = node->xmlChildrenNode;
  while (node) {
    if (!xmlStrcmp(node->name, BAD_CAST "title")) {
      tmp = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
      if (title)
	free(title);
      title = NULL;
      if (tmp) {
	title = strdup((char *)tmp);
	xmlFree(tmp);
      }
    } else if (!xmlStrcmp(node->name, BAD_CAST "url")) {
      tmp = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
      if (url)
	free(url);
      url = NULL;
      if (tmp) {
	url = strdup((char *)tmp);
	xmlFree(tmp);
      }
    } else if (!xmlStrcmp(node->name, BAD_CAST "template")) {
      tmp = xmlNodeListGetString(doc, node->xmlChildrenNode, 1);
      if (templatefile)
	free(templatefile);
      templatefile = NULL;
      if (tmp) {
	templatefile = validateFileName((const char *)tmp);
	xmlFree(tmp);
      }
    }

    node = node->next;
  }
  xmlFreeDoc(doc);

  if (!title)
    return false;

  return true;
}

int cVideoService::Compare(const cListObject &ListObject) const {
  cVideoService *obj = (cVideoService *)&ListObject;
  return strcasecmp(title, obj->GetTitle());
}
