/*
 * parser.h: Web video plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */


#ifndef __WEBVIDEO_PARSER_H
#define __WEBVIDEO_PARSER_H

#include <libxml/parser.h>
#include "download.h"
#include "menu.h"

extern cCharSetConv csc;

enum eParsingError {
  PARSING_OK = 0,
  PARSING_UNKNOWN_ERROR,
  PARSING_XSLT_ERROR,
  PARSING_NO_URL,
  PARSING_NO_MEM
};

// --- cVideoInfo ----------------------------------------------------------

class cVideoInfo {
 private:
  char *url;
  char *title;
 public:
  cVideoInfo(const char *url, const char *title);
  ~cVideoInfo();

  char *GetURL() { return url; };
  char *GetTitle() { return title; };
  // Returns a pointer to null terminated string that contains the
  // file extension of this url (for example ".flv"). Returns empty
  // string if no extension can be found. The caller should free the
  // memory.
  char *GetExtensionFromURL();
};

// --- cParser -------------------------------------------------------------

class cParser {
private:
  // Extract child node contents from a single <link> node.
  static void HandleLinkNode(xmlDocPtr doc, xmlNode *node, xmlChar **title, xmlChar **url, eLinkType *type, xmlChar **templatefile);
  // Find href attribute recursively from ASX document
  static char *GetRefRecursively(xmlNodePtr node);
public:
  // Load a XSLT file from a file called xsltfile, and apply it to the
  // HTML document in memory buffer. Returns the resulting parsed
  // document as an xmlDocPtr object, or NULL if the parsing fails.
  static xmlDocPtr ApplyXSLT(const char *webpage, int size, const char *URL,
			     const char *xsltfile);
  // Apply an XSLT transformation read from xsltfile to the string
  // webpage. Size is the length of the webpage buffer, and URL points
  // to the URL where the webpage was downloaded. Returns the
  // resulting XML document in a string, which the caller must free.
  static char *ApplyXSLTDump(const char *webpage, int size, const char *URL,
			     const char *xsltfile);
  // Transform webpage (which has been retrieved from URL) using XSLT
  // template xsltfile, and return the extracted information in
  // videoinfo pointer.
  static eParsingError ParseVideoPage(cMemoryBuffer *webpage, const char *URL,
				      const char *xsltfile, cVideoInfo **videoinfo);
  // Get the first url found on a ASX page, and return a pointer to
  // malloc()ed string in urlout. The caller should free the memory.
  static eParsingError ParseASXPage(const char *asxpage, char **urlout);
};

#endif // __WEBVIDEO_PARSER_H
