/*
 * menu.h: Web video plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */

#ifndef __WEBVIDEO_MENU_H
#define __WEBVIDEO_MENU_H

#include <vdr/osdbase.h>
#include <vdr/menuitems.h>
#include <libxml/parser.h>
#include "service.h"
#include "download.h"

enum  eLinkType {
  UNKNOWN_LINK = 0,
  VIDEO_LINK,
  NAVIGATION_LINK,
  PREV_LINK,
  NEXT_LINK
};

// --- cHistory ------------------------------------------------------------

class cHistoryPage : public cListObject {
private:
  char *xmlstr;
public:
  cHistoryPage(char *xml) { xmlstr = xml; }
  ~cHistoryPage() { free(xmlstr); }

  char *GetXML() { return xmlstr; }
};

class cHistory : public cList<cHistoryPage> {
private:
  cHistoryPage *current;
public:
  cHistory();
  void Clear();
  void TruncateAndAdd(cHistoryPage *page);
  void Home();
  cHistoryPage *Back();
  cHistoryPage *Forward();
  cHistoryPage *Current() { return current; }
};

// --- cQueryObject --------------------------------------------------------

class cQueryObject {
protected:
  virtual ~cQueryObject() {}; // avoids "virtual functions but
			      // non-virtual destructor" warning
public:
  virtual char *AsQueryFragment() = 0;
};

// --- cOsdLinkItem --------------------------------------------------------

class cOsdLinkItem : public cOsdItem {
private:
  char *url;
  char *templateFile;
  char *id;
  eLinkType type;
public:
  cOsdLinkItem(const char *Title, const char *ID, const char *Url,
               eLinkType Type, const char *TemplateFile);
  ~cOsdLinkItem();

  const char *GetTemplate() { return templateFile; }
  const char *GetURL() { return url; }
  const char *GetID() { return id; }
  eLinkType GetType() { return type; }
};

// --- cMenuEditStrQueryObject ---------------------------------------------

class cMenuEditStrQueryObject : public cMenuEditStrItem, public cQueryObject {
private:
  char *id;
  char *valuebuffer;
  int valuebufferlength;
public:
  cMenuEditStrQueryObject(const char *Name, char *Value, int Length, const char *ID, const char *Allowed = NULL);
  ~cMenuEditStrQueryObject();

  virtual char *AsQueryFragment();
};

// --- cMenuEditStraQueryObject --------------------------------------------

class cMenuEditStraQueryObject : public cMenuEditStraItem, public cQueryObject {
private:
  char *id;
  int *valueptr;
  int numstrings;
  char **strings;
  char **stringids;
public:
  cMenuEditStraQueryObject(const char *Name, int *Value, int NumStrings, char **Strings, 
		      char **StringIDs, const char *ID);
  ~cMenuEditStraQueryObject();

  virtual char *AsQueryFragment();
};

// --- cXMLMenu --------------------------------------------------

class cXMLMenu : public cOsdMenu {
protected:
  virtual void Deserialize(xmlDocPtr doc, xmlNodePtr root);
  virtual cOsdItem *CreateItemFromTag(xmlDocPtr doc, xmlNodePtr node) = 0;
public:
  cXMLMenu(const char *Title, int c0 = 0, int c1 = 0, 
           int c2 = 0, int c3 = 0, int c4 = 0);

  int Load(const char *xmlstr);
};

// --- cNavigationMenu -----------------------------------------------------

class cVideoInfo;

class cNavigationMenu : public cXMLMenu {
private:
  cVector<cQueryObject *> queryObjects;
protected:
  char *configdir;
  cHistory *history;
  cDownloaderThread *downloadthread;
  char *queryurl;
  char *querytemplate;

  virtual void Deserialize(xmlDocPtr doc, xmlNodePtr root);
  virtual cOsdItem *CreateItemFromTag(xmlDocPtr doc, xmlNodePtr node);
  cOsdItem *NewLinkItem(xmlDocPtr doc, xmlNodePtr node);
  cMenuEditStrItem *NewTextField(xmlDocPtr doc, xmlNodePtr node);
  cMenuEditStraItem *NewItemList(xmlDocPtr doc, xmlNodePtr node);
public:
  cNavigationMenu(const char *Title, const char *configpath, 
                  cHistory *History, cDownloaderThread *dlthread, 
                  int c0 = 0, int c1 = 0, int c2 = 0, int c3 = 0, int c4 = 0);
  virtual ~cNavigationMenu();

  virtual eOSState ProcessKey(eKeys Key);
  virtual eOSState Select(void);
  virtual eOSState SendQuery();
  virtual void Clear(void);
  void SetConfigPath(const char *path);
  void DownloadVideo(cVideoInfo *videoinfo);
  int GoToURL(const char *url, eLinkType type, const char *templatefile);
  void Populate(cHistoryPage *page);
  eOSState HistoryBack();
  eOSState HistoryForward();
};

// --- cWebvideoMenu -------------------------------------------------------

class cWebvideoMenu : public cOsdMenu {
private:
  cNavigationMenu *navigationMenu;
  char *configpath;
  cList<cVideoService> *services;
  cDownloaderThread *downloadthread;
  cHistory *history;
public:
  cWebvideoMenu(cList<cVideoService> *servicelist, cDownloaderThread *dlthread);
  virtual ~cWebvideoMenu();
  virtual eOSState ProcessKey(eKeys Key);
  virtual eOSState Select(void);
};

// --- cStatusScreen -------------------------------------------------------

class cStatusScreen : public cOsdMenu {
public:
  cStatusScreen(cDownloaderThread *thread);
};

#endif // __WEBVIDEO_MENU_H
