/*
 * common.h: Web video plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */

#ifndef __WEBVIDEO_COMMON_H
#define __WEBVIDEO_COMMON_H

#ifdef DEBUG
#define debug(x...) dsyslog("Webvideo: " x);
#define warning(x...) esyslog("Webvideo: Warning: " x);
#define error(x...) esyslog("Webvideo: " x);
#else
#define debug(x...) ;
#define warning(x...) esyslog("Webvideo: Warning: " x);
#define error(x...) esyslog("Webvideo: " x);
#endif

extern char *downloaddir;
extern const char *VERSION;

// Return the extension of the url or NULL, if the url has no
// extension. The caller must free the returned string.
char *extensionFromUrl(const char *url);
// Returns a "safe" version of filename. Currently just removes / from
// the name. The caller must free the returned string.
char *validateFileName(const char *filename);
int moveFile(const char *oldpath, const char *newpath);
// Read the contents of a file to a NUL-terminated buffer, and return
// a pointer to it. The caller must free the memory.
char *readTextFile(const char *filename);

#endif // __WEBVIDEO_COMMON_H
