/*
 * parser.h: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */

#ifndef __PARSER_H
#define __PARSER_H
#include <vdr/tools.h>
#include <vdr/interface.h>
#include "defines.h"

int   rss_parser(char * filename);
char  *stripspaces (char *str);
char  *striphtml (char *s);
int   dl_page(char *str);

// --- cItem ------------------------------------------------------------
class cItem : public cListObject {
private:
  char title[MAXTEXTLEN];
  char desc[MAXTEXTLENLONG];
  char date[MAXTEXTLEN];
  char target[MAXTEXTLENLONG];
public:
  cItem(const char *Title, const char *Desc, const char *Date, const char *Target);
  cItem();
  void Clear(void);
  char *GetTitle(void)          { return title; }
  char *GetDesc(void)           { return desc; }
  char *GetDate(void)           { return date; }
  char *GetTarget(void)         { return target; }
  void SetTitle(const char *s)  { dsyslog ("vod/rss_parser: Title: '%s'\n", s); strncpy(title, s, MAXTEXTLEN); }
  void SetDesc(const char *s)   { dsyslog ("vod/rss_parser: Desc: '%s'\n", s); strncpy(desc, s, MAXTEXTLENLONG); }
  void SetDate(const char *s)   { dsyslog ("vod/rss_parser: Date: '%s'\n", s); strncpy(date, s, MAXTEXTLEN); }
  void SetTarget(const char *s) { dsyslog ("vod/rss_parser: Target: '%s'\n", s); strncpy(target, s, MAXTEXTLENLONG); }
};

// --- cItems------------------------------------------------------------
class cItems : public cList<cItem> {
private:
  cItem *current;
public:
};

#endif //__PARSER_H

