/*
 * i18n.c: Internationalization
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: i18n.c,v 1.15 2004/11/30 20:08:24 schmitzj Exp $
 *
 */

#include "i18n.h"

const tI18nPhrase tvoPhrases[] = {
  { "TV-OnScreen", // English
    "TV-OnScreen", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "TV-ohjelmat", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "Shows the EPG info in form of a typical TV magazine", // English
    "", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "TV-ohjelmatiedot (OSD)", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "o'clock", // English
    "Uhr", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    " ", // suomi (empty space)
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "%d-%m", // English
    "%d.%m.", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "%d.%m.", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "Press 1 for help", // English
    "Fr Hilfe die 1 drcken", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Paina '1' nhdksesi opasteen", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "Timer conflict!", // English
    "Timer Konflikt!", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    " ", // suomi (empty space)
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },

// Prefs
  { "show channel logos", // English
    "zeige Kanal-Logos", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Nyt kanavien logot", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "use XL fonts", // English
    "benutze XL Schrift", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Kyt XL-kirjasinta", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "hide info line", // English
    "verstecke Info Zeile", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Piilota inforivi", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "show channel names", // English
    "zeige Kanal-Namen", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Nyt kanavien nimet", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "show logos in black&white", // English
    "zeige Kanal-Logos in Schwarz/Wei", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Nyt logot mustavalkoisina", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "enable color problem work around", // English
    "Farbproblem Umgehung aktivieren", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Saksalainen vrikorjaus", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "user point in time 1 (Key 4)", // English
    "Anwenderzeitpunkt 1 (Taste 4)", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Ajankohta #1 (nppin '4')", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "user point in time 2 (Key 5)", // English
    "Anwenderzeitpunkt 2 (Taste 5)", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Ajankohta #2 (nppin '5')", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "user point in time 3 (Key 6)", // English
    "Anwenderzeitpunkt 3 (Taste 6)", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Ajankohta #3 (nppin '6')", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "jump to next day point if ago", // English
    "Gehe zum nchsten Tag wenn vorbei", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Siirry tarvittaessa seur. pivn", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "Show search item itself", // English
    "Zeige auch Suchbegriff", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Nyt hakuehto", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },

// Help
  { "NORMAL MODE:", // English
    "NORMALER MODUS:", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "NORMAALITILA:\n", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "arrows\n\tmove view", // English
    "Pfeile\n\tAnsicht bewegen", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "'Nuolinppimet'\n\tohjaa nkym", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "back\n\tclose TV OnScreen", // English
    "back\n\tschliee TV OnScreen", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "'Takaisin'\n\tsulje laajennos", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "red/blue\n\t-/+ one day", // English
    "rot/blau\n\t-/+ ein Tag", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "'Punainen'/'Sininen'\n\tyksi piv eteen/taaksepin", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "green/yellow\n\tone page left/right", // English
    "grn/gelb\n\teine Seite links/rechts", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "'Vihre'/'Keltainen'\n\tseuraava/edellinen sivu", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "7/9\n\tone page left/right", // English
    "7/9\n\teine Seite links/rechts", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "'7'/'9'\n\tseuraava/edellinen sivu", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "8\n\tgoto current channel", // English
    "8\n\tgehe zum aktuellen Kanal", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "'8'\n\tsiirry nykyiselle kanavalle", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "0\n\tgoto now", // English
    "0\n\tgehe zur aktuellen Zeit", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "'0'\n\tsiirry nykyhetkeen", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "4/5/6\n\tgoto configured time", // English
    "4/5/6\n\tgehe zu eingestellten Zeitpunkten", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "'4'/'5'/'6'\n\tsiirry mriteltyyn ajankohtaan", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "ok\n\tswitch to edit mode\n", // English
    "ok\n\taktiviere Editier-Modus\n", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "'OK'\n\tvaihda muokkaustilaan\n", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "EDIT MODE:", // English
    "EDITIER MODUS:", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "MUOKKAUSTILA:\n", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "back\n\tback to normal mode", // English
    "back\n\tzurck zum normalen Modus", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "'Takaisin'\n\tvaihda normaalitilaan", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "arrows\n\tmove selected schedule", // English
    "Pfeile\n\tSendung auswhlen", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "'Nuolinppimet'\n\tvalitse ohjelma", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "record\n\tcreate timer", // English
    "record\n\terzeuge Timer", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "'Tallenna'\n\tluo ajastin", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "ok\n\tshow details", // English
    "ok\n\tzeige Sendungsdetails", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "'OK'\n\tnyt listiedot", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
// End Help

// Details
  { "Record", // English
    "Aufnehmen", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Tallenna", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "Search", // English
    "Suchen", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Etsi", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "AutoTimer", // English
    "AutoTimer", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "AutoTimer", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "Added AutoTimer to vdradmin.", // English
    "AutoTimer in vdradmin aufgenommen.", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "AutoTimer listty VDRAdminiin.", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "Startoption 'vdradminfile' not set!", // English
    "Startoption 'vdradminfile' nicht gesetzt!", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Kynnistysoptio 'vdradminfile' puuttuu!", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },

// Search
  { "Search for", // English
    "Suche nach", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Etsitn termi", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "Searching...", // English
    "Suchen...", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Etsitn...", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "Nothing found!", // English
    "Nichts gefunden!", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "", // suomi
    "Ei lydetty!", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "Back", // English
    "Zurck", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Takaisin", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "Details", // English
    "Details", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Listiedot", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },
  { "in all", // English
    "in allen", // Deutsch
    "", // Slovenski
    "", // Italiano
    "", // Nederlands
    "", // Portugus
    "", // Franais
    "", // Norsk
    "Etsi kaikki", // suomi
    "", // Polski
    "", // Espaol
    "", // 
    "", // Svenska
    "", // Romaneste
    "", // Magyar
    "", // Catal
#if VDRVERSNUM >= 10302
    ""  //  (Russian)
#if VDRVERSNUM >= 10307
    "", // Hrvatski (Croatian)
#if VDRVERSNUM >= 10313
    "", // Eesti
#if VDRVERSNUM >= 10316
    "", // Dansk
#endif
#endif
#endif
#endif
  },

  { NULL }
  };
