#ifndef ROTOR_MENUITEM_H
#define ROTOR_MENUITEM_H

#include <vdr/menuitems.h>

int Width(char c);
int Width(const char *s);

const char* ThreeItems(const char* first,const char* second, const char* third, int edw);

const char* CenterText(const char* txt, int edw);

class cMenuEditEWItem : public cOsdItem {
public:
  cMenuEditEWItem(const char *Name);
  virtual eOSState ProcessKey(eKeys Key);
};

class cMenuEditStepsEWItem : public cOsdItem {
private:
  int steps,edw;
public:
  cMenuEditStepsEWItem();
  virtual eOSState ProcessKey(eKeys Key);
};

class cMenuEditLimitsItem : public cOsdItem {
public:
  cMenuEditLimitsItem(const char *Name);
  virtual eOSState ProcessKey(eKeys Key);
};

class cMenuEditFreqItem : public cOsdItem {
private:
  int *value,edw;
  char *value2;
  char *name;
  eOSState state;
public:
  cMenuEditFreqItem(const char *Name,int *Value,char *Value2, eOSState State = osUnknown);
  void Set();
  virtual eOSState ProcessKey(eKeys Key);
};

class cRotorPos;

class cMenuEditSatItem : public cOsdItem {
private:
  cRotorPos** spos;
  int* pos;
  bool* assign;
  int edw;
public:
  cMenuEditSatItem(cRotorPos** SPos,int* p, bool& Assign);
  void Set();
  eOSState ProcessKey(eKeys Key);
};

class cMenuEditSymbItem : public cMenuEditIntItem {
protected:
  char *name;
  int edw;
  virtual void Set();
  eOSState state;
public:
  cMenuEditSymbItem(const char *Name, int *Value, int Min = 0, int Max = INT_MAX, eOSState State = osUnknown);
  virtual eOSState ProcessKey(eKeys Key);
};

class cMenuEditIntpItem : public cMenuEditIntItem {
protected:
  virtual void Set(void);
  const char *falseString, *trueString;
  int *value2;
public:
  cMenuEditIntpItem(const char *Name, int *Value, int Min = 0, int Max = INT_MAX, int *Value2=0, const char *FalseString = "", const char *TrueSting = NULL);
  virtual eOSState ProcessKey(eKeys Key);
};


class cMenuEditRotorConfItem : public cOsdItem {
private:
  cRotorPos* sat;
  int* cp;
public:
  cMenuEditRotorConfItem(int* CP);
  void Set();
  eOSState ProcessKey(eKeys Key);
};

#endif
