/*
 * radioskin.h - part of radio.c, a plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 */

#ifndef __RADIO_SKIN_H
#define __RADIO_SKIN_H


enum eRadioSkin
{
  eRadioSkinDummy,
  eRadioSkinClassicDefault,
  eRadioSkinSttngDefault,
  eRadioSkinEgalsTryDefault,
  eRadioSkinEgalsTryBlue,
  eRadioSkinEnigmaDefault,
  eRadioSkinEnigmaDarkBlue,
  eRadioSkinEnigmaWineRed,
  eRadioSkinEnigmaAppleGreen,
  eRadioSkinEnigmaWomensLike,
  eRadioSkinEnigmaYellowSun,
  eRadioSkinDeepBlueDefault,
  eRadioSkinSilverGreenDefault,
  eRadioSkinLightBlueDefault,
  eRadioSkinSoppalusikkaDefault,
  eRadioSkinSoppalusikkaMint,
  eRadioSkinSoppalusikkaOrange,
  eRadioSkinSoppalusikkaVanilla,
  eRadioSkinSoppalusikkaBlackberry,
  eRadioSkinSoppalusikkaCitron,
  eRadioSkinElchiDefault,
  eRadioSkinElchiPluginDefault,
  eRadioSkinEgalOrangeDefault,
  eRadioSkinMoronimoDefault,
  eRadioSkinDuotoneDefault,
  eRadioSkinMaxNumber
};

struct cRadioSkin
{
  const char *name;		// Theme~Skin
  int clrTitleBack;		// Title-Background
  int clrTitleText;		// Title-Text
  int clrBack;			// Background
  int clrText;			// Text
};
extern const cRadioSkin radioSkin[eRadioSkinMaxNumber];

int theme_skin(void);


#endif //__RADIO_SKIN_H
