/*
 * i18n.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 */

//***************************************************************************
// Includes
//***************************************************************************

#include "i18n.h"
#include <stdio.h>

//***************************************************************************
// Constants
//***************************************************************************

const tI18nPhrase Phrases[] =
{
   {
		"Childlock plugin",       // English
		"Kindersicherung",        // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Protection Parentale",   // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Gyerekzr", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Pin Code: ", // English
		"Pin Eingabe: ", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Le code pin", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Pin kd", // Magyar
		"", // Catala
		" ", // Russian
		"", // Croatian
	},
   {
		"Skip protected channel silent", // English
		"Gesperrte Kanle ohne Meldung berspringen", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Les chanes protgs seront ignores sans infos", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Zrolt csatornkat nem megjelenteni", // Magyar
		"", // Catala
		"   ", // Russian
		"", // Croatian
	},
   {
		"Pin inactivity time [min]", // English
		"Sperre aktivieren nach Inaktivitt [min]", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Protection aprs une inactivites de [min]", // Franais
		"", // Norsk
		"", // Suomi
        "", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Zr aktivlsa [perc] inaktivits utn", // Magyar
		"", // Catala
		"   []", // Russian
		"", // Croatian
	},
   {
		"Ignoring invalid pin", // English
		"Ungltiger code", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Le code est fau", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"rvnytelen pin kd", // Magyar
		"", // Catala
		"  ", // Russian
		"", // Croatian
	},
   {
		"Please enable pin protection first", // English
		"Bitte zuerst Kindersicherung freischalten", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Entre le code de protection", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Krem oldja fel a gyerekzrat", // Magyar
		"", // Catala
		"    ", // Russian
		"", // Croatian
	},
   {
		"Recording protected, enter pin code first", // English
		"Aufnahme gesperrt, bitte Kindersicherung freischalten", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Entre le code de protection", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Krem oldja fel a gyerekzrat", // Magyar
		"", // Catala
		"    ", // Russian
		"", // Croatian
	},
   {
		"already protected", // English
		"bereits gesperrt", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Est dj protgs", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Korbban mr zrolt", // Magyar
		"", // Catala
		" ", // Russian
		"", // Croatian
	},
   {
		"added to protection list", // English
		"hinzugefgt", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"ajouter", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Zroltakhoz hozzadva", // Magyar
		"", // Catala
		"   ", // Russian
		"", // Croatian
	},
   {
		"Recording protected", // English
		"Aufnahme gesperrt", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Engeristrement protgs, d'abord mettre le code parental", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Felvtelhez fel kell oldja a gyerekzrat", // Magyar
		"", // Catala
		" ,    ", // Russian
		"", // Croatian
	},
   {
		"channel is protected", // English
		"Kanal gesperrt", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Chanes protge", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Csatorna zrolva", // Magyar
		"", // Catala
		" ", // Russian
		"", // Croatian
	},
   {
		"broadcast is protected", // English
		"Sendung gesperrt", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Emission protge", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Ads zrolva", // Magyar
		"", // Catala
		" ", // Russian
		"", // Croatian
	},
   {
		"Activated pin protection", // English
		"Kindersicherung aktiviert", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Activ la protection parentale", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Gyerekzr aktivlva", // Magyar
		"", // Catala
		" ", // Russian
		"", // Croatian
	},
   {
		"Childlock",       // English
		"Kindersicherung", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Protection parentale", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Gyerekzr", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Delete", // English
		"Lschen", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Effacer", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Trls", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Add", // English
		"Hinzufgen", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Ajouter", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Hozzads", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Protected channels", // English
		"Gesperrte Kanle", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Chanes protgs", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Lezrt csatornk", // Magyar
		"", // Catala
		" ", // Russian
		"", // Croatian
	},
   {
		"Protected broadcasts", // English
		"Gesperrte Sendungen", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Emissions protgs", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Lezrt adsok", // Magyar
		"", // Catala
		" ", // Russian
		"", // Croatian
	},
   {
		"Plugin protections", // English
		"Sperren / Entsperren", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Plugin sous protection", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Add current channel to protection list", // English
		"Aktuellen Kanal sperren", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Ajouter la chane actuelle  la protection parentale", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Aktulis csatorna zroltakhoz adsa", // Magyar
		"", // Catala
		"    .  ", // Russian
		"", // Croatian
	},
   {
		"Add current broadcast to protection list", // English
		"Aktuelle Sendung sperren", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Ajouter l'mission actuelle dans la liste de protection parentale", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Aktulis ads zroltakhoz adsa", // Magyar
		"", // Catala
		"    . ", // Russian
		"", // Croatian
	},
   {
		"Edit channel locks", // English
		"Gesperrte Kanle bearbeiten", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Editer la liste de chanes", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Zrolt csatornk szerkesztse", // Magyar
		"", // Catala
		"  ", // Russian
		"", // Croatian
	},
   {
		"Edit broadcast locks", // English
		"Gesperrte Sendungen bearbeiten", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Editer les missions protgs", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Zrolt adsok szerkesztse", // Magyar
		"", // Catala
		"  ", // Russian
		"", // Croatian
	},
   {
		"Edit plugin locks", // English
		"Systemeinstellungen bearbeiten", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"editer la protection de plugin", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Edit menu locks", // English
		"Mensperren bearbeiten", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Lock setup", // English
		"Setup sperren", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Unlock setup", // English
		"Setup entsperren", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Activate childlock", // English
		"Kindersicherung aktivieren", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Protection parentales active", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Gyerekzr aktivlsa", // Magyar
		"", // Catala
		" ", // Russian
		"", // Croatian
	},
   {
		"Remove entry?", // English
		"Eintrag entfernen?", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Enlever?", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Trlse?", // Magyar
		"", // Catala
		"?", // Russian
		"", // Croatian
	},
   {
		"Edit", // English
		"Bearbeiten", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Editer", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Channel", // English
		"Kanal", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Chane", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Csatorna", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Lock active", // English
		"Sperre aktiv", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Protection active", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Zr aktivlva", // Magyar
		"", // Catala
		" ", // Russian
		"", // Croatian
	},
   {
		"already in list", // English
		"bereits in der Liste", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
 		"Toujours dans la liste", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"mar a zaroltak kztt", // Magyar
		"", // Catala
		"  ", // Russian
		"", // Croatian
	},
   {
		"Protected channels", // English
		"Gesperrte Kanle", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Protger chane", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Vdett csatornk", // Magyar
		"", // Catala
		" ", // Russian
		"", // Croatian
	},
   {
		"Protected broadcasts", // English
		"Gesperrte Sendungen", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Proteger l'mission", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Vdett adsok", // Magyar
		"", // Catala
		" ", // Russian
		"", // Croatian
	},
   {
		"regular expression", // English
		"regulrer Ausdruck", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Expression rgulire", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"regulris kifejezs", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Keyword", // English
		"Suchbegriff", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Expression de recherche", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Kulcssz", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"includes", // English
		"enthlt", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"incluent", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"tartalmazza", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"exact", // English
		"entspricht", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"exactement", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"megeggyezik", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"start with", // English
		"beginnt mit", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Title", // English
		"Titel", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Titre", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Cm", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"always", // English
		"immer", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"toujours", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Mindig", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"intelligent", // English
		"intelligent", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"intelligent", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"inteligens", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"never", // English
		"nie", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"jamais", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"soha", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Autoprotection of recordings", // English
		"Automatischer Schutz der Aufnahmen", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Protection automatique des enregistrement", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"Automatikus vdelem felvtel ellen", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"is protected", // English
		"ist gesperrt", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"est protg", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Open menu after pin request", // English
		"Men nach Eingabe des Pin ffnen", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Ouvrir le menu aprs la rentr de la cled", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Recording was already protected!", // English
		"Aufnahme bereits gesperrt!", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"L'enregeristrement est en protection parentale!", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Recording now protected!", // English
		"Sperre aktiviert!", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"L'enregeristrement est en protection parentale maintenant!", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Recording was not protected!", // English
		"Aufnahme ist nicht gesperrt!", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"L'enregeristrement n'avait pas de protection parentale!", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Removed protection of recording!", // English
		"Sperre entfernt!", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"La protection parentale est enlever!", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Please setup a pin code first!", // English
		"Bitte konfigurieren zuerst einen Pin Code!", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Entrer le code de protection d'abord!", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Please enter pin code first", // English
		"Bitte zuerst Pin Code eingeben", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Entr d'abord le code", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"locked", // English
		"gesperrt", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"protg", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"unlocked", // English
		"entsperrt", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"libr", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"On/Off", // English
		"An/Aus", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Enclencher/dclencher", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Invalid Code !", // English
		"Falsche Eingabe !", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Le code est faux!", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Code accepted", // English
		"Eingabe angenommen", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Le code est accept", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Setup your pin code: ", // English
		"Bitte Pin Code festlegen: ", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Introduisez le code d'accs:", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Pin code successfully setup", // English
		"Pin Code erfolgreich festgelegt.", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Le code d'accs est accept", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Menu protections", // English
		"Men sperren", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Protgier des menus", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Hide protected menus", // English
		"Gesperrte Mens verstecken", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Menu protgs sont invisibles", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Hide protected plugins", // English
		"Gesperrte Plugins verstecken", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Plugins protgs sont invisibles", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
		"Hide protected recordings", // English
		"Gesperrte Aufnahmen verstecken", // Deutsch
		"", // Slovenski
		"", // Italiano
		"", // Nederlands
		"", // Portugus
		"Enregistrements protgs sont invisibles", // Franais
		"", // Norsk
		"", // Suomi
		"", // Polski
		"", // Espaol
		"", // Ellinika
		"", // Svenska
		"", // Romaneste
		"", // Magyar
		"", // Catala
		"", // Russian
		"", // Croatian
	},
   {
      NULL
   }
};
