/*
 * Image plugin to VDR (C++)
 *
 * (C) 2004-2006 Andreas Brachold    <anbr at users.berlios.de>
 * based on (C) 2003 Kai Tobias Burwieck      <kai-at-burwieck.net>
 *
 * based on MP3/MPlayer plugin to VDR (C++)
 * (C) 2001,2002 Stefan Huelswitt <huels-at-iname.com>
 *
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <vdr/tools.h>
#include <vdr/config.h>
#include "setup-image.h"
#include "i18n.h"

cImageSetup ImageSetup;

const int cImageSetup::m_cSSMin = 2;
const int cImageSetup::m_cSSMax = 300;


// --- cImageSetup -----------------------------------------------------------

cImageSetup::cImageSetup(void)

{
  m_bSlideShow = 1;
  m_nSSsec = 10;
  m_bAutoRepeat = 1;

  Coversize     = 3;
  AutoMusic     = 0;
  max_osdleft   = 29;
  max_osdtop    = 11;
  max_osdwidth  = 653;
  max_osdheight = 563;
  EnableFade    = 1;
  strncpy(MusicDir, "/vdr_daten/mp3", sizeof(MusicDir));
}

#define ParseInteger(szTitle,nValue,nMin,nMax) \
  if(!strcasecmp(szName, szTitle))             \
  {                                            \
    nValue = atoi(szValue);                    \
    if(nValue < nMin) nValue = nMin;           \
    if(nValue > nMax) nValue = nMax;           \
  } 


bool cImageSetup::SetupParse(const char *szName, const char *szValue)
{
       ParseInteger("SlideShow",     m_bSlideShow,0,1)
  else ParseInteger("SSsec",         m_nSSsec,m_cSSMin,m_cSSMax)
  else ParseInteger("AutoRepeat",    m_bAutoRepeat,0,1)
  else if(!strcasecmp(szName,"Coversize"))        ImageSetup.Coversize      = atoi(szValue);
  else if(!strcasecmp(szName,"Max_OSDLeft"))      ImageSetup.max_osdleft    = atoi(szValue);
  else if(!strcasecmp(szName,"Max_OSDTop"))       ImageSetup.max_osdtop     = atoi(szValue);
  else if(!strcasecmp(szName,"Max_OSDWidth"))     ImageSetup.max_osdwidth   = atoi(szValue);
  else if(!strcasecmp(szName,"Max_OSDHeight"))    ImageSetup.max_osdheight  = atoi(szValue);
  else if(!strcasecmp(szName,"EnableFade"))       ImageSetup.EnableFade     = atoi(szValue);
//  else if(!strcasecmp(szName,"AutoMusic"))        ImageSetup.AutoMusic      = atoi(szValue);
  else if(!strcasecmp(szName,"MusicDir"))         strn0cpy(ImageSetup.MusicDir, szValue, sizeof(ImageSetup.MusicDir));
  else return false;
  return true;
}

// --- cMenuSetupImage --------------------------------------------------------
void cMenuSetupImage::Store(void)
{
  ImageSetup = m_tmpSetup;
  SetupStore("SlideShow",               ImageSetup.m_bSlideShow);
  SetupStore("SSsec",                   ImageSetup.m_nSSsec);
  SetupStore("AutoRepeat",              ImageSetup.m_bAutoRepeat);
  SetupStore("Coversize",               ImageSetup.Coversize);
  SetupStore("Max_OSDLeft",		ImageSetup.max_osdleft);
  SetupStore("Max_OSDTop",		ImageSetup.max_osdtop);
  SetupStore("Max_OSDWidth",		ImageSetup.max_osdwidth);
  SetupStore("Max_OSDHeight",		ImageSetup.max_osdheight);
  SetupStore("EnableFade",		ImageSetup.EnableFade);
//  SetupStore("AutoMusic",               ImageSetup.AutoMusic);
  SetupStore("MusicDir",                ImageSetup.MusicDir);
}

cMenuSetupImage::cMenuSetupImage(void)
: m_tmpSetup(ImageSetup)
{
  static const char allowed[] = { "abcdefghijklmnopqrstuvwxyz-_@/" };

  SetSection(tr("Image"));

  Add(new cMenuEditBoolItem(tr("Slide show"),                    
        &m_tmpSetup.m_bSlideShow,    
        tr("no"), tr("yes")));

  Add(new cMenuEditIntItem (tr("Slide duration (sec)"),           
        &m_tmpSetup.m_nSSsec,        
        cImageSetup::m_cSSMin, cImageSetup::m_cSSMax));

  Add(new cMenuEditBoolItem(tr("Repeat slide show"),               
        &m_tmpSetup.m_bAutoRepeat,   
        tr("no"), tr("yes")));


  coversize[0]=tr("119x119");
  coversize[1]=tr("273x273");
  coversize[2]=tr("299x255");
  coversize[3]=tr("Fullscreen");
  Add(new cMenuEditStraItem(tr("Picture size"),
        &m_tmpSetup.Coversize,
	4, coversize));


  Add(new cMenuEditIntItem(tr("Offset left")                  , &m_tmpSetup.max_osdleft  , 0 , 50));
  Add(new cMenuEditIntItem(tr("Offset top")                   , &m_tmpSetup.max_osdtop   , 0 , 50));
  Add(new cMenuEditIntItem(tr("Width")                        , &m_tmpSetup.max_osdwidth , 320 , 720));
  Add(new cMenuEditIntItem(tr("Height")                       , &m_tmpSetup.max_osdheight, 320 , 576));
  Add(new cMenuEditBoolItem(tr("Enable Fading")               , &m_tmpSetup.EnableFade , tr("no") , tr("yes")));
//  Add(new cMenuEditBoolItem(tr("Play music in background")    , &m_tmpSetup.AutoMusic , tr("no") , tr("yes")));
  Add(new cMenuEditStrItem(tr("Path to music library")        ,  m_tmpSetup.MusicDir , 255, allowed));

}
