/*
 * Image plugin to VDR (C++)
 *
 * (C) 2004-2005     A. Brachold   <anbr at users.berlios.de>
 *  
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#include <string.h>
 
#include "list.h"
#include "data-image.h"
#include "setup-image.h"

#include <vdr/tools.h>

cActivSlideShow theSlideShow;

cActivSlideShow::cActivSlideShow()
: m_pCurSlideShow(NULL)
, m_nCurrentImage(0)
, m_nTotalImages(0)
, m_pCurImage(NULL)
{

}

void cActivSlideShow::Remove(cFileSource* src){

  if(m_pCurSlideShow) {
    cImage* p = m_pCurSlideShow->cList < cImage >::First();
    while (p) {
    if(p->CompareBaseDir(src)) {
      bool bRemoveCurrent = (m_pCurImage == p); 
      m_pCurSlideShow->cList < cImage >::Del(p);
      p = m_pCurSlideShow->cList < cImage >::First();
      if(bRemoveCurrent) {
        m_nCurrentImage = 1;
        m_pCurImage = p;
      }
    } else {
      p = m_pCurSlideShow->cList < cImage >::Next(p);
    }
    }
    m_nTotalImages = m_pCurSlideShow->cList < cImage >::Count();
  }
} 

void cActivSlideShow::Assign(cSlideShow *pCurSlideShow)
{
  Shutdown();
  m_nCurrentImage = 0;
  m_nTotalImages = 0;
  m_pCurSlideShow = pCurSlideShow;
  if(m_pCurSlideShow) {

    m_nTotalImages = m_pCurSlideShow->Count();
    // get real Index of FirstImage
    unsigned int i = 0;
    bool bFound = false;
    if(m_pCurSlideShow->FirstImage()) {

      cImage* p = m_pCurSlideShow->cList < cImage >::First();

        for (;p && i < m_nTotalImages; ++i) {
        // find out first image
        if(0 == strcmp(::basename(p->Name()),m_pCurSlideShow->FirstImage())) {
          m_pCurImage = p;
          bFound = true;
          break;
        }
        p = m_pCurSlideShow->cList < cImage >::Next(p);
      }
    }
    if(bFound) {
      m_nCurrentImage = i+1;
    }
    else {
      m_pCurImage = m_pCurSlideShow->cList < cImage >::First();
      m_nCurrentImage = 1;
    }


  printf("count: %d\n", m_nTotalImages);
  }
}

void cActivSlideShow::Shutdown(void)
{
  if(m_pCurSlideShow) {
    delete m_pCurSlideShow;
    m_pCurSlideShow = 0;
    m_pCurImage = 0;
    m_nCurrentImage = 0;
    m_nTotalImages = 0;
  }
}

cSlideShow *cActivSlideShow::SlideShow(void)
{
  return m_pCurSlideShow;
}


cImage* cActivSlideShow::GetImage()
{
  return m_pCurSlideShow?m_pCurImage:NULL;
}


bool cActivSlideShow::NextImage(int nOffset)
{
  if(m_pCurImage && m_nCurrentImage < m_nTotalImages) {
    cImage *pNewActiv;
    for (int i = 0; (i < nOffset) && (m_nCurrentImage < m_nTotalImages); ++i) {
      pNewActiv = m_pCurSlideShow->cList < cImage >::Next(m_pCurImage);
      m_pCurImage = pNewActiv;
      ++m_nCurrentImage;
    }
    return m_pCurImage != NULL;
  } 
  else if(ImageSetup.m_bAutoRepeat) {
    cImage *pNewActiv;
    
    pNewActiv = m_pCurSlideShow->cList < cImage >::First();
    m_pCurImage = pNewActiv;
    m_nCurrentImage = 1;
    
    return m_pCurImage != NULL;
  }
  return false;
}



bool cActivSlideShow::PrevImage(int nOffset)
{
  if(m_pCurImage && m_nCurrentImage > 1) {
    cImage *pNewActiv;

    for (int i = 0; (i < nOffset) && (m_nCurrentImage > 1); ++i) {
        pNewActiv = m_pCurSlideShow->cList < cImage >::Prev(m_pCurImage);
        m_pCurImage = pNewActiv;
        --m_nCurrentImage;
    }
    return m_pCurImage != NULL;
  }
  else if(ImageSetup.m_bAutoRepeat) {
    cImage *pNewActiv;

    pNewActiv = m_pCurSlideShow->cList < cImage >::Last();
    m_pCurImage = pNewActiv;
    m_nCurrentImage = m_nTotalImages;
      return m_pCurImage != NULL;
  }
  return false;
}


bool cActivSlideShow::GotoImage(unsigned int nNewPictureIndex)
{
  if(m_pCurImage && nNewPictureIndex > 0 && nNewPictureIndex < m_nTotalImages) {
    cImage *pNewActiv;
    pNewActiv = m_pCurSlideShow->cList < cImage >::First();
    m_pCurImage = pNewActiv;
    m_nCurrentImage = 0;
    for (unsigned int i = 0; i < nNewPictureIndex; ++i) {
      pNewActiv = m_pCurSlideShow->cList < cImage >::Next(m_pCurImage);
      m_pCurImage = pNewActiv;
      ++m_nCurrentImage;
    }
    return m_pCurImage != NULL;
	}
  return false;
}

int cActivSlideShow::GetJumpNames(int nOffset,cImage* pImage[],const unsigned int nMAX_BILDER)
{
  unsigned int i;
  cImage *pNewActiv;
  int nBilder = 0;

  if(m_pCurImage && m_nCurrentImage > 0) {
  
	  int nJumpFirst = m_nCurrentImage + nOffset;

      if(nJumpFirst > ((int)(m_nTotalImages - nMAX_BILDER + 1)))
		  nJumpFirst = ((int)(m_nTotalImages - nMAX_BILDER + 1));
	  if(nJumpFirst < 1)
		  nJumpFirst = 1;
	  
	  m_nCurrentImage = nJumpFirst;
      if(m_nCurrentImage > m_nTotalImages)
		  m_nCurrentImage = m_nTotalImages;
	  if(m_nCurrentImage < 1)
		  m_nCurrentImage = 1;

    pNewActiv = m_pCurSlideShow->cList < cImage >::First();
    for (int n = 1; n < nJumpFirst && pNewActiv; ++n) 
      pNewActiv = m_pCurSlideShow->cList < cImage >::Next(pNewActiv);
	  for (i = 0; (i < nMAX_BILDER) && ((nJumpFirst + i) <= m_nTotalImages) && pNewActiv; ++i,++nBilder) {

      pImage[i] = pNewActiv;
	    dsyslog("picselshow: File%d: %s", i, pNewActiv->Name());
	    if((nJumpFirst + i) == m_nCurrentImage)
		    m_pCurImage = pNewActiv;
	    pNewActiv = m_pCurSlideShow->cList < cImage >::Next(pNewActiv);
	  }
  }
  return nBilder;
}
