/*
 * viewer.h: Viewer core
 *
 * PhotoCD Player plugin for VDR (the Video Disk Recorder)
 * Copyright (C) 2002  Thomas Heiligenmann  <thomas@heiligenmann.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301 USA
 *
 */


#ifndef __PCD_VIEWER_H
#define __PCD_VIEWER_H

#include <vdr/player.h>
#include <vdr/thread.h>
#include <vdr/remux.h>
#include <vdr/ringbuffer.h>
#include "functions.h"

class cPcdViewer;

class cPcdViewerControl : public cControl {
private:
  cPcdViewer *viewer;
public:
  cPcdViewerControl(int Image, cPCD *Pcd);
  virtual ~cPcdViewerControl();
  bool Active(void);
  int GetImage(void);
  void Stop(void);
  bool SkipImages(int Images);
  bool ZoomImage(int Zoom);
  bool PanImage(int X, int Y, int Off);
  void GotoImage(int Image);
  void ToggleSlideshow(void);
};

#endif //__PCD_VIEWER_H
