/*
 * setup.h: Setup the plugin
 *
 * PhotoCD Player plugin for VDR (the Video Disk Recorder)
 * Copyright (C) 2002  Thomas Heiligenmann  <thomas@heiligenmann.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301 USA
 *
 */


#ifndef __PCD_SETUP_H
#define __PCD_SETUP_H

#include <vdr/menuitems.h>
#include "functions.h"

class cPcdSetupData {
public:
  int DriveSpeed;
  int HideMainMenuEntry;
  int Quality;
  int Pal;
  int QuickScaling;
  int NoAdjust;
  int SlideInterval;
public:
  cPcdSetupData(void);
};

class cPcdSetupMenu : public cMenuSetupPage {
private:
  cPCD *pcd;
  cPcdSetupData setupData;
protected:
  virtual void Store(void);
public:
  cPcdSetupMenu(cPCD *Pcd);
};

extern cPcdSetupData PcdSetupData;

#endif //__PCD_SETUP_H
