/*
 * setup.c: Setup the plugin
 *
 * PhotoCD Player plugin for VDR (the Video Disk Recorder)
 * Copyright (C) 2002  Thomas Heiligenmann  <thomas@heiligenmann.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301 USA
 *
 */

#include <vdr/menuitems.h>
#include "setup.h"
#include "i18n.h"

cPcdSetupData PcdSetupData;

// --- cVcdSetupData ---------------------------------------------------------

cPcdSetupData::cPcdSetupData(void)
{
  DriveSpeed = 8;
  HideMainMenuEntry = 0;
  Quality = 9;
  Pal = 1;
  QuickScaling = 0;
  SlideInterval = 10;
}


// --- cPcdSetupMenu ---------------------------------------------------------

cPcdSetupMenu::cPcdSetupMenu(cPCD *Pcd)
{
  pcd = Pcd;
  setupData = PcdSetupData;
  SetSection(tr("PCD"));
  Add(new cMenuEditIntItem(tr("Setup.PhotoCD$Drive speed"), &setupData.DriveSpeed, 1, 50));
  Add(new cMenuEditBoolItem(tr("Setup.PhotoCD$Hide main menu entry"), &setupData.HideMainMenuEntry));
  Add(new cMenuEditIntItem(tr("Setup.PhotoCD$MPEG quality"), &setupData.Quality, 1, 31));
  Add(new cMenuEditBoolItem(tr("Setup.PhotoCD$Pal"), &setupData.Pal));
  Add(new cMenuEditBoolItem(tr("Setup.PhotoCD$Quick scaling"), &setupData.QuickScaling));
  Add(new cMenuEditBoolItem(tr("Setup.PhotoCD$No adjustment"), &setupData.NoAdjust));
  Add(new cMenuEditIntItem(tr("Setup.PhotoCD$Slideshow interval (sec)"), &setupData.SlideInterval, 5, 300));
}

void cPcdSetupMenu::Store(void)
{
  PcdSetupData = setupData;
  SetupStore("DriveSpeed", PcdSetupData.DriveSpeed);
  pcd->SetDriveSpeed(PcdSetupData.DriveSpeed);
  SetupStore("HideMainMenuEntry", PcdSetupData.HideMainMenuEntry);
  SetupStore("Quality", PcdSetupData.Quality);
  SetupStore("Pal", PcdSetupData.Pal);
  SetupStore("Quickscaling", PcdSetupData.QuickScaling);
  SetupStore("Nofit", PcdSetupData.NoAdjust);
  SetupStore("SlideshowInterval", PcdSetupData.SlideInterval);
}
