/*
 * pcd.c: main
 *
 * PhotoCD Player plugin for VDR (the Video Disk Recorder)
 * Copyright (C) 2002  Thomas Heiligenmann  <thomas@heiligenmann.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301 USA
 *
 */

#include <getopt.h>
#include <stdlib.h>
#include <vdr/plugin.h>
#include "functions.h"
#include "i18n.h"
#include "menu.h"
#include "setup.h"

static const char *VERSION        = "0.9";
static const char *DESCRIPTION    = "PhotoCD Player";
static const char *MAINMENUENTRY  = "PhotoCD";

class cPluginPcd : public cPlugin {
private:
  cPCD *pcd;
public:
  cPluginPcd(void);
  virtual ~cPluginPcd();
  virtual const char *Version(void) { return VERSION; }
  virtual const char *Description(void) { return DESCRIPTION; }
  virtual const char *CommandLineHelp(void);
  virtual bool ProcessArgs(int argc, char *argv[]);
  virtual bool Start(void);
  virtual void Housekeeping(void);
  virtual const char *MainMenuEntry(void);
  virtual cOsdObject *MainMenuAction(void);
  virtual cMenuSetupPage *SetupMenu(void);
  virtual bool SetupParse(const char *Name, const char *Value);
};

cPluginPcd::cPluginPcd(void)
{
  pcd = NULL;
}

cPluginPcd::~cPluginPcd()
{
  delete pcd;
}

const char *cPluginPcd::CommandLineHelp(void)
{
  return NULL;
}

bool cPluginPcd::ProcessArgs(int argc, char *argv[])
{
  return true;
}

bool cPluginPcd::Start(void)
{
  RegisterI18n(Phrases);
  pcd = new cPCD("/dev/cdrom");
  return true;
}

void cPluginPcd::Housekeeping(void)
{
}

const char *cPluginPcd::MainMenuEntry(void)
{
  if (PcdSetupData.HideMainMenuEntry)
     return NULL;
  if (pcd->DriveExists())
     return tr(MAINMENUENTRY);
  else
     return NULL;
}

cOsdObject *cPluginPcd::MainMenuAction(void)
{
  return new cPcdMenu(pcd);
}

cMenuSetupPage *cPluginPcd::SetupMenu(void)
{
  return new cPcdSetupMenu(pcd);
}

bool cPluginPcd::SetupParse(const char *Name, const char *Value)
{
  if (!strcasecmp(Name, "DriveSpeed"))
     PcdSetupData.DriveSpeed = atoi(Value);
  else if (!strcasecmp(Name, "HideMainMenuEntry"))
     PcdSetupData.HideMainMenuEntry = atoi(Value);
  else if (!strcasecmp(Name, "Quality"))
     PcdSetupData.Quality = atoi(Value);
  else if (!strcasecmp(Name, "Pal"))
     PcdSetupData.Pal = atoi(Value);
  else if (!strcasecmp(Name, "Quickscaling"))
     PcdSetupData.QuickScaling = atoi(Value);
  else if (!strcasecmp(Name, "Noadjust"))
     PcdSetupData.NoAdjust = atoi(Value);
  else if (!strcasecmp(Name, "SlideshowInterval"))
     PcdSetupData.SlideInterval = atoi(Value);
  else
     return false;
  return true;
}

VDRPLUGINCREATOR(cPluginPcd); // Don't touch this!
