/*
 * mpeg.h: Generate MPEG still image
 *
 * PhotoCD Player plugin for VDR (the Video Disk Recorder)
 * Copyright (C) 2002  Thomas Heiligenmann  <thomas@heiligenmann.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301 USA
 *
 */

#ifndef __PCD_MPEG_H
#define __PCD_MPEG_H

#include <vdr/tools.h>
extern "C" {
#include <libavcodec/avcodec.h>
};

#define TMP_WIDTH   768
#define TMP_HEIGHT  576
#define PAL_WIDTH   704
#define PAL_HEIGHT  576
#define NTSC_WIDTH  704
#define NTSC_HEIGHT 480

class cMpegFrame {
private:
  AVCodec *avCodec;
  AVCodecContext *avContext;
  AVFrame *avFrame;
  unsigned char *buffer;
  bool pal;
  int width, height;
  int bufferSize, mpegSize;
public:
  cMpegFrame(bool Pal);
  virtual ~cMpegFrame();
  void Encode(unsigned char *Image);
  unsigned char* Data(void) { return buffer; }
  int Size(void) { return mpegSize; }
};

#endif //__PCD_MPEG_H
