/*
 * menu.h: OSD menus
 *
 * PhotoCD Player plugin for VDR (the Video Disk Recorder)
 * Copyright (C) 2002  Thomas Heiligenmann  <thomas@heiligenmann.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301 USA
 *
 */


#ifndef __PCD_MENU_H
#define __PCD_MENU_H

#include <vdr/osd.h>
#include "functions.h"
#include "viewer.h"


class cPcdMenu : public cOsdMenu {
protected:
  cPCD *pcd;
  eOSState Play(void);
  eOSState Eject(void);
public:
  cPcdMenu(cPCD *Pcd);
  ~cPcdMenu();
  virtual eOSState ProcessKey(eKeys Key);
};

#endif //__PCD_MENU_H
