#!/bin/bash

# parameter
# 1 : Full path to track ( e.g. "/media/mp3/album/Madonna/Best_of/Holiday.mp3" )
# 2 : Path where to copy tracks ( e.g. "/media/mobilephone/audio" )
# 3 : Name of artist ( e.g. "Madonna" )
# 4 : Name of album ( e.g. "Best of" )
# 5 : Path to artists cover directory ( e.g. "/media/pictures/cover" )
# 6 : Path to music configuration  ( e.g. "/etc/vdr/plugins/music" )

TARGET=$2
CONFIG=$6
SVDRCMD="/usr/bin/svdrpsend.pl"

OLD_IFS=$IFS
IFS='
'

FILE=`cat $CONFIG/playlists/burnlist.m3u`

echo "Beginne mit Kopiervorgang der Tracks"

$SVDRCMD MESG "Kopiervorgang gestartet"

for i in $FILE; do
cp -f "$i" "$TARGET"
done

echo "Tracks kopiert..."

# comment this if you dont copy to a flashdevice (otherwise it didnt hurt.. ;))
echo "Warte 5 Sekunden vor Syncronisierung"
sleep 5
sync


IFS=$OLD_IFS

$SVDRCMD MESG "Kopiervorgang abgeschlossen !"

echo "FERTIG !"

# mit Iso vorher
# ---------------
#echo "Tracks kopiert..erstelle ISO"
#mkisofs -r -J -o /tmp/mp3burn.iso /tmp/burn

#echo "ISO erstellt..starte Brennvorgang"
#cdrecord -v dev=ATA:1,0,0 speed=4 /tmp/mp3burn.iso

## BURN MP3-CD

# on the fly with 4MB buffer..
# ---------------
#echo "Tracks kopiert..starte Brennvorgang on-the-fly"
#mkisofs -r /tmp/burn | cdrecord -v fs=4m speed=4 dev=ATA:1,0,0 -


## BURN AUDIO-CD
#cdrecord -v -audio -pad dev=ATA:1,0,0 speed=4 /tmp/track*.wav

#echo "Entferne temporre Dateien..."
#rm -f /tmp/burn/*.*
#echo "Fertig !"

#echo "CD erstellt"
