#ifndef __MP3CONTROL_H
#define __MP3CONTROL_H

#include <string>
#include <vdr/menuitems.h>
#include <vdr/status.h>
#include <vdr/skins.h>
//#include <vdr/timers.h>

#include "player-mp3.h"
#include "commands.h"
#include "rating.h"
#include "tracklist.h"


class cMP3Control : public cControl , public cStatus {
private:
  cOsd *osd;
  std::string imagefile;
  std::string _message;
  const cFont *font;
 
  int x1, fw, fh, depth, rows;
  //
  cMP3Player *player;

  cMP3Commands *cmdMenu;
  cMP3Rating *rateMenu;
  cTrackList *trackList;

  bool copyfile, visible, refresh, flush, skiprew, skipfwd;
  int cw, coversize, lastkeytime, num, number, playstatus, laststatus;
  bool selecting, artistfirst, muted, showmessage;
  //
  cMP3PlayInfo *lastMode;
  time_t fliptime, listtime;
  int flip, flipint, osdwidth, osdtop, osdleft, osdheight, showbuttons;
  int lastIndex, lastTotal;
  int framesPerSecond;
  int vol;
  
  char lastfile[256];
  char oldcoverpicture[256];
  
  char *rating;
  //
  bool jumpactive, jumpsecs, ShowSA, force;
  int jumpmm, channelsSA, bandsSA, visualization;
  //
  static cBitmap bmShutdown,bmShuffle,bmLoop,bmStop,bmPlay,bmPause,
                 bmCopy,bmText,bmRec,bmVol,bmMute;

  static cBitmap bmDelStar,bmRate00,bmRate05,bmRate10,bmRate15,bmRate20,
                 bmRate25,bmRate30,bmRate35,bmRate40,bmRate45,bmRate50;
/*
  static cBitmap bmv100,bmv095,bmv090,bmv085,bmv080,bmv075,bmv070,
                 bmv065,bmv060,bmv055,bmv050,bmv045,bmv040,bmv035,
                 bmv030,bmv025,bmv020,bmv015,bmv010,bmvMute;
  */
  // , bmRec;
  //
  int clrBG;
  int clrTopBG;
  int clrTopFG;
  int clrCoverBG;
  int clrCoverBar;
  int clrArtistBG;
  int clrArtistFG;
  int clrRatingFG;
  int clrPlayStatusBG;
  int clrPlayStatusFG;
  int clrInfoBG;
  int clrInfoFG;
  int clrProgressbarBG;
  int clrProgressbarFG;
  int clrListTitle;
  int clrListBG;
  int clrListFG;
  int clrSymbolBG;
  int clrSymbolFG;
  int clrSymbolActive;
  int clrRecordingActive;
  int clrStatusBG;
  int clrStatusFG;
  int clrStatusRed;
  int clrStatusGreen;
  int clrStatusYellow;
  int clrStatusBlue;
  int imgalpha;
  int mpgdif;
  //
  const cFont *pFontUser;
  const cFont *pFontText;
  const cFont *pFontList;
  const cFont *pFontListActive;
  const cFont *pFontTitle;
  const cFont *pFontInfo;
  const cFont *pFontCommands;
  //
  void ShowCoverOnly(bool open=false);
  void ShowSAOnly(bool open=false);
  void ShowHelpButtons(int ShowButtons);
  void ConvertRatingToChar(int value, int bgClr, int fgClr);
  void SetVars(void);
  void SetFonts(void);
  void SetVol(void);
  void ShowTracks(void);
  void ShowProgress(bool open=false);
  void DisplayInfo(const char *s=0);
  void JumpDisplay(void);
  void JumpProcess(eKeys Key);
  void Jump(void);
  void ShowMessage(int Message, bool open);  
  eOSState MessageProcess(eKeys Key);
  void Stop(void);
  void LoadCover(void);
  void CopyTrack(void);
  inline void Flush(void);
  void ShutDown(void);
  
public:
  cMP3Control(void);
  virtual ~cMP3Control();
  virtual eOSState ProcessKey(eKeys Key);
  virtual void Hide(void);
  bool Visible(void) { return visible; }
  static bool SetPlayList(cPlayList *plist);
};

#endif // __MP3CONTROL_H
