#ifndef __MOSAICOSD_H
#define __MOSAICOSD_H

#include <vdr/osd.h>
#include <vdr/device.h>
#include <vdr/menuitems.h>
#include <ctype.h>
#include "gfxtools.h"
#include "mosaicbmp.h"

static const cFont *font = cFont::GetFont(fontOsd);
static const int LINEHEIGHT = font->Height();
#define NBLINES 4

class cMosaicOsd : public cOsdObject {
private:
  void DrawSymbol(int x, int y, const char *SymbolName[], tColor color);
  cOsd *osd;
  int pal[16];
  int lastTime;
  int number;
  int group;
  int mosa[4][4][5];
  int track[2][4][5];
  int ChannelOrigNumber;
  int row,col,mos;
  int mosaic[5];
  eTrackType types[ttMaxTrackTypes];
  int numTracks;
  char ChanName[255];
  int extraInfo;
  const cEvent *Present;
  const cEvent *Following;
  const cEvent **pArray;
  const char *textPresentInfo;
  const char *textFollowingInfo;
  const char *titlePresentInfo;
  const char *titleFollowingInfo;
  const char *subtitlePresentInfo;
  const char *subtitleFollowingInfo;
  int currentEvent;
  int offset;
  int lines;
  int type;
  
public:
  cMosaicOsd(void);
  ~cMosaicOsd();
  virtual void Show(void);
  virtual eOSState ProcessKey(eKeys Key);
  int parse_file(const char *filename);
  int GetChannelNumberByName(char *name);
  void SendPalette(void);
  void SetColor(int Index, int Red, int Green, int Blue, int Alpha);
  void ClearBitmap(void);
  
  void UpdateEPGInfo(int NowPrevNext);
  void DrawMenu(int delta, int highlight);
  void DisplayBitmap(void); 
  void DisplayInfo(int delta);
  void DisplayExtraInfo(void);
  void DisplayChannel(const cChannel *Channel);
  char *WrapText(const char *Text, int Width, int *Height);
};

#endif //__MOSAICOSD_H
