
#include "cpumonsetup.h"
 
const char *displaymode[] = { NULL, NULL, NULL };
const char *int_unit [] = { NULL, NULL, NULL };

cCpuMonSetup::cCpuMonSetup(cParameters *p)
{
  parms = p;
  
  displaymode[0] = tr("points");
  displaymode[1] = tr("lines");
  displaymode[2] = tr("solid");
  
  int_unit[0] = tr("milliseconds");
  int_unit[1] = tr("seconds");
  int_unit[2] = tr("minutes");
  
  new_polling   = parms->polling();
  new_pi_unit   = parms->pi_unit();
  new_d_mode    = parms->d_mode();
  
  Add(new cOsdItem(tr("Polling"), osUnknown, false));
  
  Add(new cMenuEditIntItem(tr("polling interval"),              &new_polling, 1, 1000));
  Add(new cMenuEditStraItem(tr("polling interval unit"),        &new_pi_unit, 3, int_unit));
  
  Add(new cOsdItem(tr("Appearance"), osUnknown, false));
  Add(new cMenuEditStraItem(tr("display mode"),    		&new_d_mode, 3,   displaymode));
};

cCpuMonSetup::~cCpuMonSetup(void)
{
};
 
void cCpuMonSetup::Store(void)
{
  parms->set_pi_unit(new_pi_unit);
  
  // polling greater 10 milliseconds
  if((parms->pi_unit() == 0) &&
     (new_polling < 10))
    new_polling = 10;
  
  parms->set_polling(new_polling);
    
  parms->set_d_mode(new_d_mode);
  
  
  SetupStore("polling_interval", new_polling );
  SetupStore("pi_unit", 	 new_pi_unit );
  SetupStore("display_mode",     new_d_mode);
};

