#ifndef _CPUMON_FETCHER_H_
#define _CPUMON_FETCHER_H_

#include <vdr/plugin.h>
#include <vdr/thread.h>
#include <vdr/status.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include "parms.h"

#define VAL_COUNT 150
#define USER   0
#define NICE   1
#define SYSTEM 2
#define IDLE   3

static const char DName[] = "/proc/stat";

// ---------------------------------------------------------------------
struct s_order
{
  int val;
  unsigned int func;
};

// ---------------------------------------------------------------------
/* tMeasured - a data structure containing the jiffie values
 */
struct tMeasured
{
  unsigned int val[4],
               // 0:user,   /* jiffies in user mode                          */
               // 1:nice,   /* jiffies in user mode with low priority (nice) */
	       // 2:system, /* jiffies in system mode                        */
	       // 3:idle,   /* jiffies in idle task                          */
	                    /* jiffie = 1/100 second                         */
	       sum,         /* sum of all four values                        */
	       index;
  s_order      order[4];    /* contains the ordering of the 4 functions      */
	       
  tMeasured*   next;
};


// ---------------------------------------------------------------------
/* cCPUUsageFetcher - responsible for reading the
 * /proc/stat file and to extract the most important
 * values from it.
 */ 
class cCpuMonFetcher: public cThread
{
private:
  FILE *Datei;
  char name[7];
  tMeasured measurements[2];
  tMeasured  *values_head,
             *act_values,     // pointer the the actual element
	     *int_act_values; // internal pointer the the actual element

  cCondWait timer;
  cParameters *parms;
  unsigned int round(float x);
public:
  cCpuMonFetcher(cParameters *pparms);
  ~cCpuMonFetcher();

  virtual void Action();
  int fetch_values();
  void Stop();
  tMeasured* get_head();
  tMeasured* get_act_val();
  void reset_values();
};

#endif
