/*
 * cpuMon.c: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id$
 */

#include "cpumon.h"

// Constructor
cPluginCpuMon::cPluginCpuMon(void)
{
  // Initialize any member variables here.
  // DON'T DO ANYTHING ELSE THAT MAY HAVE SIDE EFFECTS, REQUIRE GLOBAL
  // VDR OBJECTS TO EXIST OR PRODUCE ANY OUTPUT!
  parms = new cParameters;
  Values_Fetcher = new cCpuMonFetcher(parms);
}

// Destructor
cPluginCpuMon::~cPluginCpuMon()
{
  // Clean up after yourself!
}

const char *cPluginCpuMon::CommandLineHelp(void)
{
  // Return a string that describes all known command line options.
  return NULL;
}

bool cPluginCpuMon::ProcessArgs(int argc, char *argv[])
{
  // Implement command line argument processing here if applicable.
  return true;
}

bool cPluginCpuMon::Initialize(void)
{
  RegisterI18n(Phrases);
  // Initialize any background activities the plugin shall perform.
  Values_Fetcher->Start();
  return true;
}

bool cPluginCpuMon::Start(void)
{
  // Start any background activities the plugin shall perform.
  return true;
}

void cPluginCpuMon::Stop(void)
{
  // Stop any background activities the plugin shall perform.
  Values_Fetcher->Stop();
}

void cPluginCpuMon::Housekeeping(void)
{
  // Perform any cleanup or other regular tasks.
}

void cPluginCpuMon::MainThreadHook(void)
{
  // Perform actions in the context of the main program thread.
  // WARNING: Use with great care - see PLUGINS.html!
}

cString cPluginCpuMon::Active(void)
{
  // Return a message string if shutdown should be postponed
  return NULL;
}

cOsdObject *cPluginCpuMon::MainMenuAction(void)
{
  // Perform the action when selected from the main VDR menu.
  return cCpuMonOsd::Instance(Values_Fetcher, parms);
}

cMenuSetupPage *cPluginCpuMon::SetupMenu(void)
{
  // Return a setup menu in case the plugin supports one.
  return new cCpuMonSetup(parms);
}

bool cPluginCpuMon::SetupParse(const char *Name, const char *Value)
{
  // Parse your own setup parameters and store their values.
  if      (!strcasecmp(Name, "polling_interval"))      parms->set_polling( atoi(Value) );
  else if (!strcasecmp(Name, "pi_unit"))               parms->set_pi_unit( atoi(Value) );
  else if (!strcasecmp(Name, "display_mode"))          parms->set_d_mode( atoi(Value) );
  else return false;
  return true;
}

bool cPluginCpuMon::Service(const char *Id, void *Data)
{
  // Handle custom service requests from other plugins
  return false;
}

const char **cPluginCpuMon::SVDRPHelpPages(void)
{
  // Return help text for SVDRP commands this plugin implements
  return NULL;
}

cString cPluginCpuMon::SVDRPCommand(const char *Command, const char *Option, int &ReplyCode)
{
  // Process SVDRP commands this plugin implements
  return NULL;
}


VDRPLUGINCREATOR(cPluginCpuMon); // Don't touch this!
