/*
 * Image plugin to VDR (C++)
 *
 * (C) 2004-2005 Andreas Brachold    <anbr at users.berlios.de>
 * based on (C) 2003 Kai Tobias Burwieck      <kai-at-burwieck.net>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#ifndef ___SETUP_IMAGE_H
#define ___SETUP_IMAGE_H

extern const char *g_szConfigDirectory;

#include <vdr/menuitems.h>

#ifndef MAX_PATH
#define MAX_PATH 4096
#endif

#define MAX_FILENAME 256

class cCoverSetup 
{
public:
  /* It Slideshow activ */
  int m_bSlideShow;
  /* If Slideshow activ, how many seconds between slides */
  int m_nSSsec;
  /* Should slideshow automated repeat */
  int m_bAutoRepeat;

  /** Minimum Value for Slideshow */
  static const int m_cSSMin;
  /** Maximum Value for Slideshow */
  static const int m_cSSMax;

  int Coversize;
  int max_osdleft;
  int max_osdtop;
  int max_osdwidth;
  int max_osdheight;
  int EnableFade;
  int HideMainMenu;

public:
  cCoverSetup(void);
  bool SetupParse(const char *szName, const char *szValue);
};


// ----------------------------------------------------------------

class cMenuSetupImage
	:public cMenuSetupPage 
{
  cCoverSetup m_tmpCoverSetup;
private:
  const char *coversize[4];

protected:
  virtual void Store(void);

public:
  cMenuSetupImage(void);
};


extern cCoverSetup CoverSetup;

#endif				//___SETUP_IMAGE_H
