/*
 * Coverviewer plugin to VDR (C++)
 *
 * (C) 2007 Morone
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

//#include <string>
#include <string.h>
#include <stdlib.h>
#include <fstream>
#include <vdr/plugin.h>

#include "i18n.h"
#include "parselog.h"
#include "config.h"

cCoverLog CoverLog;

// --- cCoverLog ---------------------------------------------------------------

cCoverLog::cCoverLog(void)
{
  log_artist   = "";
  log_album    = "";
  log_coverdir = "";
  log_basedir  = "";
  log_filename = "";
};


cCoverLog::~cCoverLog()
{
}

int cCoverLog::ParseLog(void)
{
  using namespace std;
  ifstream filestr;
  std::string line;
  std::string Value;
  std::string datei;

  bool result=false;

  log_artist = "";
  log_album = "";
  log_coverdir = "";
  log_basedir = "";
  log_filename = "";

  datei = configdir;
  datei = datei + "/downloads/music_cover/cover.log";

  dsyslog("coverviewer: Load logfile '%s'\n", datei.c_str());

  filestr.open (datei.c_str());
  if(filestr) {
    while (getline(filestr, line, '\n')) {
      int len = line.length();
      string::size_type pos = line.find ("<value>",0);

      if(pos != string::npos) {
        if (strstr(line.c_str(),"ARTIST")) {
          pos = line.rfind ("=",len);
          if(pos != string::npos) {
	    Value   = line.substr(pos +1,len);
	    log_artist = Value;
	  }     
        }    
        else if (strstr(line.c_str(),"ALBUM")) {
	  pos = line.rfind ("=",len);
          if(pos != string::npos) {
	    Value   = line.substr(pos +1,len);
	    log_album = Value;
          }
	}  
        else if (strstr(line.c_str(),"COVERDIR")) {
	  pos = line.rfind ("=",len);
          if(pos != string::npos) {
	    Value   = line.substr(pos +1,len);
	    log_coverdir = Value;
          }
	}  
        else if (strstr(line.c_str(),"BASEDIR")) {
	  pos = line.rfind ("=",len);
          if(pos != string::npos) {
	    Value   = line.substr(pos +1,len);
	    log_basedir = Value;
          }
	}  
        else if (strstr(line.c_str(),"FILENAME")) {
	  pos = line.rfind ("=",len);
          if(pos != string::npos) {
	    Value   = line.substr(pos +1,len);
	    log_filename = Value;
          }
	}  
      }
    }

  filestr.close();
  result = true;
  }

  return result;
}
