/*
 * Image plugin to VDR (C++)
 *
 * (C) 2004-2006 Andreas Brachold    <anbr at users.berlios.de>
 * based on (C) 2003 Kai Tobias Burwieck      <kai-at-burwieck.net>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */
// @

#include <vdr/config.h>
#include "i18n.h"

const tI18nPhrase Phrases[] = {
  { "Coverviewer", // English
    "Coveranzeige", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Affichage de couverture", // French
    "", // Norwegian
    "",    // Finnish
    "", // Polish
    "",  // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "An Cover Viewer for music plugin", // English
    "Ein Coverbetrachter fr das Musik-Plugin", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Afficheur de couverture pour le plugin lecteur de musique", // French
    "", // Norwegian
    "",  // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Artist", // English
    "Interpret", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Interprte", // French
    "", // Norwegian
    "",  // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Trackname", // English
    "Trackname", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Nom de la chanson", // French
    "", // Norwegian
    "",  // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Album", // English
    "Album", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Album", // French
    "", // Norwegian
    "",  // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Image browser", // English
    "Bilder Verzeichnisanzeige", // German
    "Image navigator", // Slovenian
    "Browser di immagine", // Italian
    "Browser van het beeld", // Dutch
    "Browser da imagem", // Portuguese
    "Navigateur images", // French
    "", // Norwegian
    "Kuvat - selain", // Finnish
    "", // Polish
    "Browser de la imagen", // Spanish
    "Image endiksi fakelon", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "   ", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Image source", // English
    "Bilder-Datentrger", // German
    "Image izvor", // Slovenian
    "Fonte di immagine", // Italian
    "De bron van het beeld", // Dutch
    "Fonte da imagem", // Portuguese
    "Source images", // French
    "", // Norwegian
    "Kuvat - lhteet", // Finnish
    "", // Polish
    "Fuente de la imagen", // Spanish
    "Pigi Image", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "(source)", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Parent", // English
    "Zurck", // German
    "Nazaj", // Slovenian
    "precursore", // Italian
    "voorloper", // Dutch
    "precursor", // Portuguese
    "Retour", // French
    "", // Norwegian
    "Takaisin", // Finnish
    "", // Polish
    "Predecesor", // Spanish
    "Piso", // Greek
    "Tillbaka", // Swedish
    "", // Romanian
    "", // Hugarian
    "Anterior", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Select", // English
    "Auswhlen", // German
    "Izberi", // Slovenian
    "Prescelto", // Italian
    "Selecteer", // Dutch
    "Seleto", // Portuguese
    "Slectionner", // French
    "", // Norwegian
    "Valitse", // Finnish
    "", // Polish
    "Seleccionar", // Spanish
    "Epilogi", // Greek
    "Vlj", // Swedish
    "", // Romanian
    "", // Hugarian
    "Escollir", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Play",
    "Wiedergabe",
    "Predvajaj",
    "Riproduci",
    "Weergeven",
    "",// TODO
    "Lecture",
    "",// TODO
    "Toista",
    "Odtworzenie",
    "Reproducir",
    "",
    "Spela upp",
    "Redare",
    "Lejtszs",
    "Reproduir",
    "",
    "Start",
    "Start",
    "Afspil",
  },
  { "Back",
    "Zurck",
    "Nazaj",
    "Indietro",
    "Terug",
    "Voltar",
    "Retour",
    "Tilbake",
    "Takaisin",
    "Wstecz",
    "Retornar",
    "",
    "Tillbaka",
    "napoi",
    "Vissza",
    "Retornar",
    "",
    "Nazad",
    "Tagasi",
    "Tilbage",
  },
  { "Error scanning directory!", // English
    "Fehler beim Lesen des Verzeichnisses!", // German
    "Napaka pri pregledovanju direktorija!", // Slovenian
    "Indice di esame di errori!", // Italian
    "Het aftastenfolder van de fout!", // Dutch
    "Diretrio da explorao do erro!", // Portuguese
    "Erreur de parcours du rpertoire!", // French
    "", // Norwegian
    "Hakemiston selaus eponnistui!", // Finnish
    "", // Polish
    "Error al leer una carpeta!", // Spanish
    "Lathos stin sarosi tou fakelou!", // Greek
    "Kunde inte lsa katalogen!", // Swedish
    "", // Romanian
    "", // Hugarian
    "Error al llegir una carpeta!", // Catalan
    "   !", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Data medium", // English
    "Datentrger", // German
    "Izvor", // Slovenian
    "Mezzo di dati", // Italian
    "Het middel van gegevens", // Dutch
    "Meio de dados", // Portuguese
    "Source", // French
    "", // Norwegian
    "Lhde", // Finnish
    "", // Polish
    "Medio de datos", // Spanish
    "Pigi", // Greek
    "Klla", // Swedish
    "", // Romanian
    "", // Hugarian
    "Orgen", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Mount", // English
    "Einbinden", // German
    "Priklopi", // Slovenian
    "supporto", // Italian
    "Zet op", // Dutch
    "Montagem", // Portuguese
    "Monter", // French
    "", // Norwegian
    "Kiinnit", // Finnish
    "", // Polish
    "Montaje", // Spanish
    "Sindesi", // Greek
    "Montera", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Unmount", // English
    "Aushngen", // German
    "Izklopi", // Slovenian
    "smonti", // Italian
    "unmount", // Dutch
    "unmount", // Portuguese
    "Dmonter", // French
    "", // Norwegian
    "Irrota", // Finnish
    "", // Polish
    "Unmount", // Spanish
    "Aposindesi", // Greek
    "Avmontera", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Selected data medium is not mounted!", // English
    "Ausgewhlter Datentrger ist nicht eingebunden!", // German
    "Izbran izvor ni prikljucen!", // Slovenian
    "Il mezzo di dati selezionato non  montato!", // Italian
    "Het geselecteerde gegevensmiddel wordt niet opgezet!", // Dutch
    "O meio de dados selecionado no  montado!", // Portuguese
    "Source slectionne non monte!", // French
    "", // Norwegian
    "Valittua lhdett ei ole kiinnitetty!", // Finnish
    "", // Polish
    "El origen deseado no est montado!", // Spanish
    "Epilegmeni Pigi den ine sindemeni!", // Greek
    "Den valda kllan r inte monterad!", // Swedish
    "", // Romanian
    "", // Hugarian
    "l'Origen sel.leccionat no est muntat!", // Catalan
    "   !", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Mount succeeded", // English
    "Einbinden erfolgreich", // German
    "Priklop izveden", // Slovenian
    "Il supporto  riuscito", // Italian
    "Zet volgend op", // Dutch
    "Montagem sucedida", // Portuguese
    "Montage russi", // French
    "", // Norwegian
    "Kiinnittminen onnistui", // Finnish
    "", // Polish
    "mount correcto", // Spanish
    "I sindesi petixe", // Greek
    "Monteringen lyckades", // Swedish
    "", // Romanian
    "", // Hugarian
    "mount correcte", // Catalan
    "  ", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Mount failed!", // English
    "Einbinden fehlgeschlagen!", // German
    "Napaka pri priklopu!", // Slovenian
    "Il supporto si guasta!", // Italian
    "Zet ontbroken op!", // Dutch
    "A montagem falha!", // Portuguese
    "Echec du montage!", // French
    "", // Norwegian
    "Kiinnittminen eponnistui!", // Finnish
    "", // Polish
    "No he podido montar!", // Spanish
    "I sindesi apetixe!", // Greek
    "Monteringen misslyckades!", // Swedish
    "", // Romanian
    "", // Hugarian
    "No he pogut muntar!", // Catalan
    " !", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Unmount succeeded!", // English
    "Aushngen erfolgreich!", // German
    "Izklop izveden!", // Slovenian
    "Smonti riuscito!", // Italian
    "Volgende Unmount!", // Dutch
    "Unmount sucedido!", // Portuguese
    "Dmontage russi!", // French
    "", // Norwegian
    "Irrottaminen onnistui!", // Finnish
    "", // Polish
    "xito al unmount", // Spanish
    "I aposindesi itan epitixisi!", // Greek
    "Avmonteringen lyckades!", // Swedish
    "", // Romanian
    "", // Hugarian
    "unmount amb xit!", // Catalan
    "  !", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Unmount failed!", // English
    "Aushngen fehlgeschlagen!", // German
    "Napaka pri izklopu!", // Slovenian
    "Smonti venuto a mancare!", // Italian
    "Ontbroken Unmount!", // Dutch
    "Unmount falhado!", // Portuguese
    "Echec du dmontage!", // French
    "", // Norwegian
    "Irrottaminen eponnistui!", // Finnish
    "", // Polish
    "No puedo desmontar!", // Spanish
    "I aposindesi den itan epitixis!", // Greek
    "Avmonteringen misslyckades!", // Swedish
    "", // Romanian
    "", // Hugarian
    "No puc desmontar!",
    " !", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Eject failed!", // English
    "Auswerfen fehlgeschlagen!", // German
    "Napaka pri izmetu!", // Slovenian
    "Espella venuto a mancare!", // Italian
    "Werp ontbroken uit!", // Dutch
    "Ejete falhado!", // Portuguese
    "Echec de l'jection!", // French
    "", // Norwegian
    "Avaaminen eponnistui!", // Finnish
    "", // Polish
    "No puedo expulsar!", // Spanish
    "I apovoli apetixe!", // Greek
    "Mata ut!", // Swedish
    "", // Romanian
    "", // Hugarian
    "No puc expulsar!", // Catalan
    "  !", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Select picture via key 1..9!", // English
    "Bildauswahl ber Taste 1..9!", // German
    "", // Slovenian
    "Selezioni l'immagine via il tasto 1..9!", // Italian
    "Selecteer beeld via knoop 1..9!", // Dutch
    "Selecione o retrato atravs da tecla 1..9!", // Portuguese
    "Selectionner l'image (touches 1..9)!", // French
    "", // Norwegian
    "Valitse kuva nppimill 1..9!", // Finnish
    "", // Polish
    "Seleccione el cuadro va el botn 1..9!", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "     1..9!", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Building slide show...", // English
    "Erzeuge Diavorfhrung...", // German
    "", // Slovenian
    "Proiezione di diapositive Della Costruzione...", // Italian
    "De Show van de Dia van de bouw...", // Dutch
    "Mostra De Corredia Do Edifcio...", // Portuguese
    "Contruction du SlideShow...", // French
    "", // Norwegian
    "Laaditaan diaesityst..", // Finnish
    "", // Polish
    "Demostracin De Diapositiva Del Edificio...", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    " ", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Scanning directory...", // English
    "Durchsuche Verzeichnis...", // German
    "", // Slovenian
    "Indice di esame...", // Italian
    "De folder van het aftasten...", // Dutch
    "Diretrio da explorao...", // Portuguese
    "Scannage du rpertoire...", // French
    "", // Norwegian
    "Selataan hakemistoa...", // Finnish
    "", // Polish
    "Leyendo las carpetas..", // Spanish
    "", // Greek
    "Sker igenom katalog...", // Swedish
    "", // Romanian
    "", // Hugarian
    "Revisant les carpetes..", // Catalan
    " ", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "No Files!", // English
    "Keine Dateien!", // German
    "", // Slovenian
    "Nessun lime!", // Italian
    "Geen dossiers!", // Dutch
    "Nenhumas Limas!", // Portuguese
    "Pas de fichiers !", // French
    "", // Norwegian
    "Ei tiedostoja!", // Finnish
    "", // Polish
    "Ningunos Archivos!", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "  !", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Slide show", // English
    "Diavorfhrung", // German
    "", // Slovenian
    "Proiezione di diapositive", // Italian
    "De show van de dia", // Dutch
    "Mostra de corredia", // Portuguese
    "Projection de diapositives", // French
    "", // Norwegian
    "Kyt diaesityst", // Finnish
    "", // Polish
    "Demostracin de diapositiva", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "?", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Slide duration (sec)", // English
    "Anzeigedauer (Sek)", // German
    "", // Slovenian
    "Faccia scorrere la durata (sec)", // Italian
    "De duur van de dia (seconde)", // Dutch
    "Deslize a durao (segundo)", // Portuguese
    "Dure entre les images (Sec)", // French
    "", // Norwegian
    "Dian esitysaika (s)", // Finnish
    "", // Polish
    "Resbale la duracin (sec)", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "  ()", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Directory with temporary files", // English
    "Verzeichnis mit temporren Dateien", // German
    "", // Slovenian
    "Indice con le lime provvisorie", // Italian
    "Folder met tijdelijke dossiers", // Dutch
    "Diretrio com limas provisrias", // Portuguese
    "Rpertoire temporaire", // French
    "", // Norwegian
    "Vliaikaistiedostot", // Finnish
    "", // Polish
    "Directorio con los ficheros temporales", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "¼ ", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Repeat slide show", // English
    "Wiederholung der Diavorfhrung", // German
    "", // Slovenian
    "Ripeti la proiezione di diapositive", // Italian
    "Herhaal diashow", // Dutch
    "Repita a mostra de corredia", // Portuguese
    "Rpter le SlideShow", // French
    "", // Norwegian
    "Diaesityksen uudelleentoisto", // Finnish
    "", // Polish
    "Repita la demostracin de diapositiva", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    " ", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Show numbers on index image", // English
    "Zeige Zahlen im Indexbild", // German
    "", // Slovenian
    "Mostri i numeri sull'immagine di indice", // Italian
    "Toon aantallen op indexbeeld", // Dutch
    "Mostre nmeros na imagem do ndice", // Portuguese
    "Afficher nombre sur la page d'index", // French
    "", // Norwegian
    "Nyt numerot indeksikuvassa", // Finnish
    "", // Polish
    "Demuestre los nmeros en imagen del ndice", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "   ", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Live Audio from primary Device", // English
    "Live Audio vom primren Gert", // German
    "", // Slovenian
    "Audio in tensione dal dispositivo primario", // Italian
    "Leef Audio van primair Apparaat", // Dutch
    "udio vivo do dispositivo preliminar", // Portuguese
    "Audio en direct", // French
    "", // Norwegian
    "Live-ni ensisijaiselta sovittimelta", // Finnish
    "", // Polish
    "Audio vivo del dispositivo primario", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    " (Live)  ", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Convert...", // English
    "Wandle...", // German
    "", // Slovenian
    "Convertito...", // Italian
    "Zet om...", // Dutch
    "Converso...", // Portuguese
    "Convertion...", // French
    "", // Norwegian
    "Konvertoi...", // Finnish
    "", // Polish
    "Convertido...", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },  
  { "Zoom", // English
    "Vergrere", // German
    "", // Slovenian
    "Zoom", // Italian
    "Gezoem", // Dutch
    "Zumbido", // Portuguese
    "Zoom", // French
    "", // Norwegian
    "Suurenna", // Finnish
    "", // Polish
    "Zumbido", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "(Zoom)", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },  
  { "Execute", // English
    "Ausfhren", // German
    "", // Slovenian
    "Esegua", // Italian
    "Voer uit", // Dutch
    "Execute", // Portuguese
    "Executer", // French
    "", // Norwegian
    "Suorita", // Finnish
    "", // Polish
    "Ejectese", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },  
  { "Operation failed", // English
    "Vorgang fehlgeschlagen", // German
    "", // Slovenian
    "Il funzionamento viene a mancare", // Italian
    "Ontbroken verrichting", // Dutch
    "A operao falhou", // Portuguese
    "Opration non russie", // French
    "", // Norwegian
    "Toiminto eponnistui", // Finnish
    "", // Polish
    "La operacin fall", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    " ", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Image couldn't load", // English
    "Konnte Bild nicht lesen", // German
    "", // Slovenian
    "L'immagine non ha potuto caricare", // Italian
    "Het beeld kon niet laden", // Dutch
    "A imagem no podia carregar", // Portuguese
    "Impossible de charger l'image", // French
    "", // Norwegian
    "Kuvan lukeminen eponnistui", // Finnish
    "", // Polish
    "La imagen no poda cargar", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "  ", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Script execution failed", // English
    "Scriptausfhrung fehlgeschlagen", // German
    "", // Slovenian
    "L'esecuzione dello scritto  venuto a mancare", // Italian
    "Ontbroken de uitvoering van het manuscript", // Dutch
    "A execuo do certificado falhou", // Portuguese
    "Impossible d'excuter le script", // French
    "", // Norwegian
    "Skriptin suoritus eponnistui", // Finnish
    "", // Polish
    "La ejecucin de la escritura fall", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "  !", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Remove temporary files", // English
    "Lsche temporre Dateien", // German
    "", // Slovenian
    "Rimuova le lime provvisorie", // Italian
    "Verwijder tijdelijke dossiers", // Dutch
    "Remova as limas provisrias", // Portuguese
    "Effacer les fichiers temporaires", // French
    "", // Norwegian
    "Tyhjenn vliaikaistiedostot", // Finnish
    "", // Polish
    "Quite los ficheros temporales", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    " tmp ", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Border for Underscan (Height)", // English
    "Rand fr Underscan (Hhe)", // German
    "", // Slovenian
    "Bordo per Underscan (altezza)", // Italian
    "Grens voor Underscan (Hoogte)", // Dutch
    "Beira para Underscan (altura)", // Portuguese
    "Frontire pour Underscan (taille)", // French
    "", // Norwegian
    "Reunuksen korkeus keskitykselle", // Finnish
    "", // Polish
    "Frontera para Underscan (altura)", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Border for Underscan (Width)", // English
    "Rand fr Underscan (Breite)", // German
    "", // Slovenian
    "Bordo per Underscan (larghezza)", // Italian
    "Grens voor Underscan (Breedte)", // Dutch
    "Beira para Underscan (largura)", // Portuguese
    "Frontire pour Underscan (largeur)", // French
    "", // Norwegian
    "Reunuksen leveys keskitykselle", // Finnish
    "", // Polish
    "Frontera para Underscan (anchura)", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Show exif informations from image", // English
    "Zeigt Exif Informationen zum Bild", // German
    "", // Slovenian
    "Mostri le informazioni del exif dall'immagine", // Italian
    "Toon exif informatie van beeld", // Dutch
    "Mostre a informao do exif da imagem", // Portuguese
    "Montrez l'information d'exif de l'image", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "Demuestre la informacin del exif de la imagen", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Could not parse exif maker note!", // English
    "Konnte Exif Erstellungsanmerkung nicht analysieren!", // German
    "", // Slovenian
    "Non ha potuto analizzare la nota del creatore del exif!", // Italian
    "Kon exif maker geen nota ontleden!", // Dutch
    "No podia analisar gramaticalmente a nota do fabricante do exif!", // Portuguese
    "N'a pas pu analyser la note de fabricant d'exif !", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "No poda analizar la nota del fabricante del exif!", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Could not load exif data from image!", // English
    "Konnte Exif Daten nicht vom Bild laden!", // German
    "", // Slovenian
    "Non ha potuto caricare i dati del exif dall'immagine!", // Italian
    "Kon exif geen gegevens van beeld laden!", // Dutch
    "No podia carregar dados do exif da imagem!", // Portuguese
    "N'a pas pu charger des donnes d'exif de l'image !", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "No poda cargar datos del exif de imagen!", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Marker", // English
    "Merkzeichen", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Marqueur", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Tags", // English
    "Bezeichnung", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Tags", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "[ -OK- FOR BROWSER ]  [ -BLUE- START MUSIC ]", // English
    "[ -OK- FFNET BROWSER ]  [ -BLAU- STARTET MUSIK ]", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "[ -OK- OUVRE LE NAVIGATEUR] [ -BLEUE- DBUT DE MUSIQUE ]", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Load...", // English
    "Lade...", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Charge...", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Enable Fading", // English
    "Aktiviere Ein-/Ausblenden", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Active le fondu", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Show infos", // English
    "Zeige Infos", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Afficher les infos", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Play music in background", // English
    "Automatische Hintergrundmusik", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Musique de fond automatique", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Path to music library", // English
    "Pfad zur Musiksammlung", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Chemin vers la collection de musique", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Cover:", // English
    "Cover:", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Couverture:", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "of", // English
    "von", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "de", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Offset left", // English
    "Offset links", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Dcallage  gauche", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Offset top", // English
    "Offset oben", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Dcallage en haut", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Width", // English
    "Breite", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Largeur", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Height", // English
    "Hhe", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Hauteur", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Picture size", // English
    "Bildgre", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Taille de l'image", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Image", // English
    "Bild", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Image", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "119x119", // English
    "119x119", // German
    "119x119", // Slovenian
    "119x119", // Italian
    "119x119", // Dutch
    "119x119", // Portuguese
    "119x119", // French
    "119x119", // Norwegian
    "119x119", // Finnish
    "119x119", // Polish
    "119x119", // Spanish
    "119x119", // Greek
    "119x119", // Swedish
    "119x119", // Romanian
    "119x119", // Hugarian
    "119x119", // Catalan
    "119x119", // Russian
    "119x119", // Hrvatski
    "119x119", // Eesti
    "119x119", // Dansk
  },
  { "273x273", // English
    "273x273", // German
    "273x273", // Slovenian
    "273x273", // Italian
    "273x273", // Dutch
    "273x273", // Portuguese
    "273x273", // French
    "273x273", // Norwegian
    "273x273", // Finnish
    "273x273", // Polish
    "273x273", // Spanish
    "273x273", // Greek
    "273x273", // Swedish
    "273x273", // Romanian
    "273x273", // Hugarian
    "273x273", // Catalan
    "273x273", // Russian
    "273x273", // Hrvatski
    "273x273", // Eesti
    "273x273", // Dansk
  },
  { "299x255", // English
    "299x255", // German
    "299x255", // Slovenian
    "299x255", // Italian
    "299x255", // Dutch
    "299x255", // Portuguese
    "299x255", // French
    "299x255", // Norwegian
    "299x255", // Finnish
    "299x255", // Polish
    "299x255", // Spanish
    "299x255", // Greek
    "299x255", // Swedish
    "299x255", // Romanian
    "299x255", // Hugarian
    "299x255", // Catalan
    "299x255", // Russian
    "299x255", // Hrvatski
    "299x255", // Eesti
    "299x255", // Dansk
  },
  { "Fullscreen", // English
    "Vollbild", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "Plein cran", // French
    "", // Norwegian
    "", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { "Hide mainmenu entry", // English
    "Hauptmeneintrag verbergen", // German
    "", // Slovenian
    "", // Italian
    "", // Dutch
    "", // Portuguese
    "", // French
    "", // Norwegian
    "Cacher l'entre dans le menu principal", // Finnish
    "", // Polish
    "", // Spanish
    "", // Greek
    "", // Swedish
    "", // Romanian
    "", // Hugarian
    "", // Catalan
    "", // Russian
    "", // Hrvatski
    "", // Eesti
    "", // Dansk
  },
  { NULL }
};

// @

