/*
 * Image plugin to VDR (C++)
 *
 * (C) 2003 Kai Tobias Burwieck <kai@burwieck.net>
*
 * based on MP3/MPlayer plugin to VDR (C++)
 * (C) 2001,2002 Stefan Huelswitt <huels@iname.com>
 *
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#ifndef ___DATA_H
#define ___DATA_H

#include <vdr/tools.h>
#include <vdr/config.h>

// ----------------------------------------------------------------

class cFileSource;

extern char *AddPath(const char *dir, const char *filename);

// ----------------------------------------------------------------

class cScanDir {
  char *QuoteString(const char *str);
protected:
  virtual void DoItem(cFileSource *src, const char *name)=0;
public:
  bool ScanDir(cFileSource *src);
  virtual ~cScanDir();
};

// ----------------------------------------------------------------

class cDirItem
: public cListObject {
public:
  cDirItem(cFileSource *src);
  ~cDirItem();
  //
  cFileSource *Source;
};

// ----------------------------------------------------------------


class cFileSource
: public cListObject {
  char *basedir;
  int useCount;
  //
  void Set(const char *Basedir);
public:
  cFileSource(void);
  cFileSource(const char *Basedir);
  ~cFileSource();
  void Block(void) { ++useCount; }
  void Unblock(void) { --useCount; }
  char *BuildName(const char *filename);
  const char *BaseDir(void) const { return basedir; }
  };

#endif //___DATA_H
