/*
 * Image plugin to VDR (C++)
 *
 * (C) 2004-2005 Andreas Brachold    <anbr at users.berlios.de>
 * (C) 2003 Kai Tobias Burwieck <kai at burwieck.net>
 *
 * based on MP3/MPlayer plugin to VDR (C++)
 * (C) 2001,2002 Stefan Huelswitt <huels at iname.com>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#include <ctype.h>
#include <dirent.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

#include "data.h"
#include "data-image.h"
#include "list.h"

#include <vdr/tools.h>

// ----------------------------------------------------------------

char *AddPath(const char *dir, const char *filename)
{
  int l = strlen(dir);
  char *name = MALLOC(char, l + strlen(filename) + 2);
  if(name)
	{
    strcpy(name, dir);
    name[l] = '/';
    strcpy(name + l + 1, filename);
  } else {
    esyslog("coverviewer: ERROR: no memory for filename");
	}
    return name;
}

		
// -- cScanDir --------------------------------------------------------------

bool cScanDir::ScanDir(cFileSource * src)
{
  bool result = true;
  char *cmd = 0, *dir = 0, *s = 0;

  asprintf(&dir, "%s", src->BaseDir());

  asprintf(&cmd, "find \"%s\"  -iname \"*.jpg\" 2>/dev/null | sort -df", QuoteString(dir));

  //fprintf(stderr,"%s\n",cmd);
  cReadLine l;
  FILE *p = popen(cmd, "r");
  if(p) {
    int len = strlen(dir);
//    char *s;
    while((s = l.Read(p)) != 0) {
      char *ss = strstr(s, dir);
      if(ss) {
        s = ss + len;
        if(*s == '/')
  				s++;
    }
    if(*s)
      DoItem(src, s);
    }
    pclose(p);
  }
  else
  	result = false;

  free(dir);
  free(cmd);
  free(s);
  return result;
}

cScanDir::~cScanDir()
{
}


char *cScanDir::QuoteString(const char *str)
{
  static char *nstr = 0;

  free(nstr);
  nstr = MALLOC(char, strlen(str) * 2);
  char *p = nstr;
  while(*str)
	{
	    switch (*str)
		{
		case '$':	// dollar
		case '\\':	// backslash
		case '\"':	// double quote
		case '`':	// back tick
		    *p++ = '\\';
		    // fall through
		default:
		    *p++ = *str++;
		    break;
		}
	}
  *p = 0;
  return nstr;
}

// -- cDirItem --------------------------------------------------------------

cDirItem::cDirItem(cFileSource * src)
{
  Source = src;
}

cDirItem::~cDirItem()
{
}

// -- cFileSource --------------------------------------------------------------

cFileSource::cFileSource(void)
{
  basedir =  0;
  useCount = 0;
}

cFileSource::cFileSource(const char *Basedir)
{
  basedir = 0;
  useCount = 0;
  Set(Basedir);
}

cFileSource::~cFileSource()
{
  free(basedir);
}

void cFileSource::Set(const char *Basedir)
{
  free(basedir);
  basedir = strdup(Basedir);
}


// WIRD GEBRAUCHT
char *cFileSource::BuildName(const char *filename)
{
  return AddPath(basedir, filename);
}
