/*
 * Image plugin to VDR (C++)
 *
 * (C) 2003 Kai Tobias Burwieck <kai at burwieck.net>
 * (C) 2004     "Interpohl"  <interpohl at vdr-portal.de> 
 * (C) 2004     A. Brachold   <anbr at users.berlios.de>
 * (C) 2004     O. Kreuzinger <Onno at Kreuzinger.biz>
 * (C) 2004     A. Holzhammer for the massive script updates
 *  
 *  based on mp3/mplayer plguin by Stefan Hlswitt <huels at iname.com>
 *   
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#include <getopt.h>
#include <vdr/plugin.h>


#include "setup-image.h"
#include "data-image.h"
#include "control-image.h"
#include "i18n.h"
#include "config.h"

static const char *VERSION        = "0.0.2";
static const char *DESCRIPTION    = "An Cover Viewer for music plugin";
static const char *MAINMENUENTRY  = "Coverviewer";

class cPluginImage : public cPlugin {
public:
  virtual ~cPluginImage();
  virtual const char *Version(void) { return VERSION; }
  virtual const char *Description(void) { return tr(DESCRIPTION); }
  virtual const char *CommandLineHelp(void);
  virtual bool ProcessArgs(int argc, char *argv[]);
  virtual bool Start(void);
  virtual const char *MainMenuEntry(void);
  virtual cOsdObject *MainMenuAction(void);
  virtual cMenuSetupPage *SetupMenu(void);
  virtual bool SetupParse(const char *Name, const char *Value);
  };

bool cPluginImage::SetupParse(const char *szName, const char *szValue)
{
	return CoverSetup.SetupParse(szName,szValue);
}

const char *g_szConfigDirectory = NULL;

const char *cPluginImage::CommandLineHelp(void)
{
  static char *help_str=0;
  
  free(help_str);    //                                     for easier orientation, this is column 80|
  asprintf(&help_str,"  -C PATH,  --config=PATH  to specify directory of music configuration data\n"
                     "                           (default: (empty))\n"
                    );
  return help_str;
}

bool cPluginImage::ProcessArgs(int argc, char *argv[])
{
  static struct option long_options[] = {
      { "config",   required_argument, NULL, 'C' },
      { NULL }
    };
    
  int c, option_index = 0;
  while((c=getopt_long(argc,argv,"C:",long_options,&option_index))!=-1) {
    switch (c) {
      case 'C': configdir=optarg;break;
      default:  return false;
      }
    }
  return true;
}

bool cPluginImage::Start(void)
{
  if(configdir == NULL) {
    configdir = strdup(ConfigDirectory("music"));
    isyslog("coverviewer: --config not set, use default path '%s'\n", configdir);
    }
  else
    isyslog("coverviewer: --config set: '%s'", configdir);
  
  RegisterI18n(Phrases);
  return true;
}

cPluginImage::~cPluginImage()
{
}

const char *cPluginImage::MainMenuEntry(void)
{
  return CoverSetup.HideMainMenu ? 0 : tr(MAINMENUENTRY);
}

cOsdObject *cPluginImage::MainMenuAction(void)
{
  return new cImageControl;
}

cMenuSetupPage *cPluginImage::SetupMenu(void)
{
  return new cMenuSetupImage;
}


VDRPLUGINCREATOR(cPluginImage); // Don't touch this!
