/*
 * Image plugin to VDR (C++)
 *
 * (C) 2004-2005 Andreas Brachold <anbr at users.berlios.de>
 * based on (C) 2003 Kai Tobias Burwieck <kai -at- burwieck.net>
 *
 * This code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

// --- cImageControl ---------------------------------------------------------

#ifndef ___DVB_IMAGE_CONTROL_H
#define ___DVB_IMAGE_CONTROL_H

#include <string>

#include <vdr/osdbase.h>

#define memberof(x) (sizeof(x)/sizeof(*x))

class cImage;
class cSlideShow;

class cImageControl : public cOsdObject
{
  /** View our picture in a slideshow */
  bool                    m_bSlideShowActiv; 
  /** date at image was open*/
  time_t                  m_tStarted;
  /** Remember the active Slideshow mode before Jump or Zoom used */
  bool                    m_bSlideShowBefore;

private:  
  cOsd *osd;
  int w,w1,h,h1,x1,depth,bmpcolors,alpha,fh,fw;
  
 //Fading
  void FadeIn(void);
  void FadeOut(void);
 // cFileSources *msources;
  void ShowOSD(bool open=false);
  void HideOSD(void);
  void ShowProgress(void);
//
//
  void CopyCover(void);
  void CopyTrack(void);
  void CopyArtist(void);
//
//  void LoadCover(void);
  bool visible, flush, CanLoadCover;
  int coversize;
  /** Deliver the current number of viewed Image */
  int ImageCurrent(void) const;
  /** Deliver the total number of viewed Image */
  int ImageTotal(void) const;
  /** Deliver the filename from the current number of viewed Image */
  const char* FileName() const;
  /** Toogle between Play and Stop of the current SlideShow */
  void ToogleSlideShowActiv(void);
  /** Path of current imagefile */
  char CurrImageFile[255];
  
  void NextImage(int Step);
  void PrevImage(int Step);
  void OriginalImage(bool bCached);
  bool CheckAccess() const;
  inline void Flush(void);
public:
  cImageControl(void);
  virtual ~ cImageControl();
  virtual eOSState ProcessKey(eKeys Key);
  virtual void Show(void);
  virtual void Hide(void);
  static void SetSlideShow(cSlideShow * pNewSlideShow);

protected:  
  void SlideImage();
  cString ServiceID;
  bool ServiceAvailable;
};

#endif				//___DVB_IMAGE_CONTROL_H
