/*
 * autotimeredit: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: menudictionary.h 1.7 2005/10/19 23:22:17 hflor Exp $
 */

#ifndef __MENUDICTIONARY_H
#define __MENUDICTIONARY_H

#include <vdr/menu.h>
#include <vdr/menuitems.h>
#include "autotimers.h"

// --- cMenuEditDictionary --------------------------------------------------------

class cMenuEditDictionary : public cOsdMenu {
private:
  cDefaultDictionary *defaultdictionary;
  cDefaultDictionary data;
  bool isdictionarselect;
  int dictionarypos;
  int dictionarysel;
  bool addIfConfirmed;
public:
  cMenuEditDictionary(cDefaultDictionary *DefaultDictionary, bool New = false);
  virtual ~cMenuEditDictionary();
  virtual void Set(void);
  virtual eOSState ProcessKey(eKeys Key);
  };

// --- cMenuDictionaryItem --------------------------------------------------------

class cMenuDictionaryItem : public cOsdItem {
private:
  cDefaultDictionary *defaultdictionary;
public:
  cMenuDictionaryItem(cDefaultDictionary *DefaultDictionary);
#if VDRVERSNUM >= 10315
  virtual int Compare(const cListObject &ListObject) const;
#else
  virtual bool operator< (const cListObject &ListObject);
#endif
  virtual void Set(void);
  cDefaultDictionary *DefaultDictionary(void) { return defaultdictionary; }
  };

// --- cMenuDictionarys -----------------------------------------------------------

class cMenuDictionarys : public cOsdMenu {
private:
  void SetHelpKeys(void);
  eOSState Edit(void);
  eOSState New(void);
  eOSState Delete(void);
  eOSState OnOff(void);
  cDefaultDictionary *CurrentDefaultDictionary(void);
public:
  cMenuDictionarys(void);
  virtual eOSState ProcessKey(eKeys Key);
  };

#endif //__MENUDICTIONARY_H
