/*
 * autotimeredit: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: ddictionary.h 1.7 2005/10/19 23:22:17 hflor Exp $
 */

#ifndef __DDICTIONARY_H
#define __DDICTIONARY_H

#include <vdr/config.h>
#include <vdr/tools.h>

#define MaxDefaultDictionary 1000

enum eSource {
  Source_none        = 0x00,
  Source_AutoTimers  = 0x01,
  Source_Timers      = 0x02,
  Source_Records     = 0x04,
  Source_Commandline = 0x08,
  Source_Setup       = 0x10,
  Source_All         = 0x1F };

class cDefaultDictionary : public cListObject {
  friend class cMenuEditDictionary;
private:
  char     dictionary[MaxFileName];
  int      source;
  int      blacklist;
  int      includesub;

public:
  cDefaultDictionary(const char *Dictionary, int Source, int Blacklist = false, int Includesub = false);
  cDefaultDictionary(cDefaultDictionary *Copy);
  cDefaultDictionary(void);
  virtual ~cDefaultDictionary(void);
  cDefaultDictionary& operator= (const cDefaultDictionary &DefaultDictionary);
#if VDRVERSNUM >= 10315
  virtual int Compare(const cListObject &ListObject) const;
#else
  virtual bool operator< (const cListObject &ListObject);
#endif

  void SetValues(const char *Dictionary, int Source, int Blacklist = false, int Includesub = false);
  const char *Dictionary(void) { return dictionary; }
  int Source(void) { return source; }
  void AddSource(int Source) { source |= Source; }
  void DelSource(int Source) { source &= ~Source; }
  bool isSource(eSource Test) { return source & Test ? true : false; }
  bool isOnlySource(eSource Test) { return source == Test ? true : false; }
  int Blacklist(void) { return blacklist; }
  int Includesub(void) { return blacklist && includesub; }
  void OnOff(void);
  };

class cDefaultDictionarys : public cList<cDefaultDictionary> {
private:
  void DelDictionarys(eSource Source);
  void AddDictionarysFromAutoTimers(void);
  void AddDictionarysFromTimers(void);
  void AddDictionarysFromRecords(void);
  void AddDictionarysFromCommandline(void);
  void AddDictionarysFromSetup(void);
  void FillDefaultDictionary(void);
public:
  int CountSource(eSource Test);
  void MergeDictionary(void);
  void AddMergeFill(void);
  int SearchDictionary(const char *Search);
};

extern cDefaultDictionarys DefaultDictionarys;
extern cDefaultDictionarys CommandlineDefaultDictionarys;
extern cDefaultDictionarys SetupDefaultDictionarys;

#endif //__DDICTIONARY_H
