/*
 * autotimeredit: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: autotimeredit.h 1.7 2005/10/19 23:22:17 hflor Exp $
 */

#ifndef __AUTOTIMER_H
#define __AUTOTIMER_H

#include "update.h"
#include <vdr/config.h>

#if VDRVERSNUM >= 10307
#define MAXOSDTEXTWIDTH 45
#define AKTOSDTEXTWIDTH 45
#define ERROR(T) Skins.Message(mtError, T)
#define INFO(I)  Skins.Message(mtInfo, I)
#else
#define MAXOSDTEXTWIDTH MAXOSDWIDTH
#define AKTOSDTEXTWIDTH Setup.OSDwidth
#define ERROR(T) Interface->Error(T)
#define INFO(I)  Interface->Info(I)
#endif

// Global variables that control the overall behaviour:

struct tParamInt {
  bool c;               // read command line
  bool r;               // read config file
  bool h;               // hide in setup menu
  int d;                // default
  int u;                // used
  int s;                // config file
  int o;                // old value for setup menu
  int i;                // ignore extentions for vdradmin.at 
  };

struct tParamFile {
  bool c;               // read command line
  bool r;               // read config file
  bool h;               // hide in setup menu
  char d[MaxFileName];  // default
  char u[MaxFileName];  // used
  char s[MaxFileName];  // config file
  char o[MaxFileName];  // old value for setup menu
  char e[MaxFileName];  // expanded name (environment)
  };

// var pos1
extern tParamFile autotimerfile;
extern tParamInt  commandline_preference;
extern tParamFile mainmenu_name;
extern tParamInt  mainmenu_visible;
extern tParamInt  num_entrys;
extern tParamInt  question;
extern tParamInt  searchlength;
extern tParamInt  show_channel;
extern tParamInt  show_channelname;
extern tParamInt  show_flags;
extern tParamInt  show_startstop;
extern tParamInt  update_b_e;
extern tParamInt  updatemethod;
extern tParamInt  updatetimerecords;
extern tParamInt  use_defaultdictionary;
extern tParamInt  use_except_repeat;
extern tParamInt  use_weekdays;
extern tParamFile vdradminconfig;
extern tParamFile vdradminupdate;
extern tParamInt  verbose;

extern char       plugin_name[MaxFileName];
extern int        q_manual_update;

extern const char *OffOnSingle[];
extern const char *StartStopTime[];
extern const char *UpdateLine[];
extern const char *UpdateMethod[];
extern const char *UpdateQuestion[];
extern const char *RecordsUpdateTime[];
extern const char *SelDefaultDictionary[];
extern       char *FileNameCharsAllowed;
extern int        CountDefaultDictionarys;

extern cUpdateThread * oUpdateThread;

int GetColumn(int selpos);
void ExpandEnvironment(tParamFile *FileStruc);

#endif //__AUTOTIMER_H
