#include <vdr/plugin.h>
#include "ac3audio.h"
#include "ac3modes.h"

cAC3ModeAudio::cAC3ModeAudio(bool _ModeChangeNotification)
    : cAudio()
{
  ac3Mode = ac3_none;
  msgThread = new cMsgThread(NULL);
  modeChangeNotification = _ModeChangeNotification;
}

void cAC3ModeAudio::Play(const uchar* Data, int Length, uchar Id)
{
  //only analyze every 10th package
  static uchar packages = 10;
    
  if (packages++ != 10)
    return;
  else
    packages = 0;
    
  if (0x80 <= Id && Id <= 0x87 || Id == 0xBD) { //AC3
    int written = Data[8] + 9; //skip PES header
	
    if (Id != 0xBD)
      written += 4; //skip AC3 bytes
	
    setAC3Mode( (written + 6 <= Length) ? Data[written + 6] >> 5 : ac3_none);
  }
  else
    setAC3Mode( ac3_none );
}

void cAC3ModeAudio::setAC3Mode(uchar newMode)
{
  if (newMode != ac3Mode)
  {
    if (modeChangeNotification)
    {
      if (!msgThread->Active())
      {
        msgThread->SetMessage(GetAC3ModeName(newMode));
        msgThread->Start();
      }
      else
      {
        //virtual ignore the change of ac3 mode
        //and try to redisplay the state in a few seconds
        newMode = ac3Mode;
      }
    }
        
    ac3Mode = newMode;
  }
}

void cAC3ModeAudio::Mute(bool on) 
{ 
  //ignore
}

void cAC3ModeAudio::Clear(void)
{
  //ignore
}
